/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.shell;

import com.beust.jcommander.JCommander;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.ratis.logservice.client.LogServiceClient;
import org.apache.ratis.logservice.shell.Command;
import org.apache.ratis.logservice.shell.CommandFactory;
import org.apache.ratis.logservice.shell.LogServiceShellOpts;
import org.apache.ratis.logservice.shell.commands.ExitCommand;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServiceShell {
    private static Logger LOG = LoggerFactory.getLogger(LogServiceShell.class);
    private static final String PROMPT = "logservice> ";
    private final Terminal terminal;
    private final LineReader lineReader;
    private final LogServiceClient client;

    public LogServiceShell(Terminal terminal, LineReader reader, LogServiceClient client) {
        this.terminal = Objects.requireNonNull(terminal);
        this.lineReader = Objects.requireNonNull(reader);
        this.client = Objects.requireNonNull(client);
    }

    public void run() {
        while (true) {
            Map.Entry<Command, String[]> pair;
            String line;
            try {
                line = this.lineReader.readLine(PROMPT);
            }
            catch (UserInterruptException e) {
                continue;
            }
            catch (EndOfFileException e) {
                break;
            }
            if (line == null || (pair = this.parseCommand(line = line.trim())) == null) continue;
            Command command = pair.getKey();
            String[] commandArgs = pair.getValue();
            if (command instanceof ExitCommand) break;
            command.run(this.terminal, this.lineReader, this.client, commandArgs);
            this.terminal.writer().flush();
        }
        this.terminal.writer().println("Bye!");
        this.terminal.writer().flush();
    }

    Map.Entry<Command, String[]> parseCommand(String line) {
        String[] words = line.split("\\s+");
        if (words.length == 0) {
            return null;
        }
        String commandWord = words[0];
        Command command = CommandFactory.create(commandWord);
        if (command == null) {
            return null;
        }
        String[] args = Arrays.copyOfRange(words, 1, words.length);
        return new AbstractMap.SimpleEntry<Command, String[]>(command, args);
    }

    public static void main(String[] args) throws Exception {
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        DefaultHistory defaultHistory = new DefaultHistory();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> LogServiceShell.lambda$main$0((History)defaultHistory)));
        LineReader lineReader = LineReaderBuilder.builder().terminal(terminal).highlighter((Highlighter)new DefaultHighlighter()).history((History)defaultHistory).build();
        LogServiceShellOpts opts = new LogServiceShellOpts();
        JCommander.newBuilder().addObject((Object)opts).build().parse(args);
        try (LogServiceClient logServiceClient = new LogServiceClient(opts.metaQuorum);){
            LogServiceShell client = new LogServiceShell(terminal, lineReader, logServiceClient);
            client.run();
        }
    }

    private static /* synthetic */ void lambda$main$0(History defaultHistory) {
        try {
            defaultHistory.save();
        }
        catch (IOException e) {
            LOG.debug("Failed to save terminal history", (Throwable)e);
        }
    }
}

