/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.api.LogInfo;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.common.LogAlreadyExistException;
import org.apache.ratis.logservice.common.LogNotFoundException;
import org.apache.ratis.logservice.common.NoEnoughWorkersException;
import org.apache.ratis.logservice.proto.MetaServiceProtos;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.logservice.util.MetaServiceProtoUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.AutoCloseableLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStateMachine
extends BaseStateMachine {
    Logger LOG = LoggerFactory.getLogger(MetaStateMachine.class);
    private Map<LogName, RaftGroup> map = new ConcurrentHashMap<LogName, RaftGroup>();
    private final Set<RaftPeer> peers = new HashSet<RaftPeer>();
    private RaftServer raftServer;
    private RaftGroup currentGroup = null;
    private PriorityBlockingQueue<PeerGroups> avail = new PriorityBlockingQueue();
    private RaftProperties properties = new RaftProperties();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private RaftGroupId metadataGroupId;
    private RaftGroupId logServerGroupId;

    public MetaStateMachine(RaftGroupId metadataGroupId, RaftGroupId logServerGroupId) {
        this.metadataGroupId = metadataGroupId;
        this.logServerGroupId = logServerGroupId;
    }

    public void initialize(RaftServer server, RaftGroupId groupId, RaftStorage storage) throws IOException {
        this.raftServer = server;
        super.initialize(server, groupId, storage);
    }

    public TransactionContext applyTransactionSerial(TransactionContext trx) {
        RaftProtos.LogEntryProto x = trx.getLogEntry();
        MetaServiceProtos.MetaSMRequestProto req = null;
        try {
            req = MetaServiceProtos.MetaSMRequestProto.parseFrom(x.getStateMachineLogEntry().getLogData());
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        switch (req.getTypeCase()) {
            case REGISTERREQUEST: {
                MetaServiceProtos.LogServiceRegisterLogRequestProto r = req.getRegisterRequest();
                LogName logname = LogServiceProtoUtil.toLogName(r.getLogname());
                RaftGroup rg = MetaServiceProtoUtil.toRaftGroup(r.getRaftGroup());
                this.map.put(logname, rg);
                this.LOG.info("Log {} registered at {} with group {} ", new Object[]{logname, this.getId(), rg});
                break;
            }
            case UNREGISTERREQUEST: {
                MetaServiceProtos.LogServiceUnregisterLogRequestProto unregReq = req.getUnregisterRequest();
                LogName logname = LogServiceProtoUtil.toLogName(unregReq.getLogname());
                this.map.remove(logname);
                break;
            }
            case PINGREQUEST: {
                MetaServiceProtos.LogServicePingRequestProto pingRequest = req.getPingRequest();
                RaftPeer peer = MetaServiceProtoUtil.toRaftPeer(pingRequest.getPeer());
                if (this.peers.contains(peer)) break;
                this.peers.add(peer);
                this.avail.add(new PeerGroups(peer));
                break;
            }
        }
        return super.applyTransactionSerial(trx);
    }

    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        return super.startTransaction(request);
    }

    public TransactionContext preAppendTransaction(TransactionContext trx) throws IOException {
        return super.preAppendTransaction(trx);
    }

    public CompletableFuture<Message> queryStale(Message request, long minIndex) {
        return super.queryStale(request, minIndex);
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        return super.applyTransaction(trx);
    }

    public CompletableFuture<Message> query(Message request) {
        if (this.currentGroup == null) {
            try {
                List x = StreamSupport.stream(this.raftServer.getGroups().spliterator(), false).filter(group -> group.getGroupId().equals((Object)this.metadataGroupId)).collect(Collectors.toList());
                if (x.size() == 1) {
                    this.currentGroup = (RaftGroup)x.get(0);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        RaftProperties properties = new RaftProperties();
        MetaServiceProtos.MetaServiceRequestProto req = null;
        try {
            req = MetaServiceProtos.MetaServiceRequestProto.parseFrom(request.getContent());
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        MetaServiceProtos.MetaServiceRequestProto.TypeCase type = req.getTypeCase();
        switch (type) {
            case CREATELOG: {
                return this.processCreateLogRequest(req);
            }
            case LISTLOGS: {
                return this.processListLogsRequest();
            }
            case GETLOG: {
                return this.processGetLogRequest(req);
            }
            case ARCHIVELOG: {
                return this.processArchiveLog(req);
            }
            case DELETELOG: {
                return this.processDeleteLog(req);
            }
        }
        CompletableFuture reply = super.query(request);
        return reply;
    }

    private CompletableFuture<Message> processDeleteLog(MetaServiceProtos.MetaServiceRequestProto logServiceRequestProto) {
        MetaServiceProtos.DeleteLogRequestProto deleteLog = logServiceRequestProto.getDeleteLog();
        LogName logName = LogServiceProtoUtil.toLogName(deleteLog.getLogName());
        RaftGroup raftGroup = this.map.get(logName);
        if (raftGroup == null) {
            return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toDeleteLogExceptionReplyProto(new LogNotFoundException(logName.getName())).build().toByteString()));
        }
        Collection peers = raftGroup.getPeers();
        peers.stream().forEach(peer -> {
            RaftClient client = RaftClient.newBuilder().setProperties(this.properties).setClientId(ClientId.randomId()).setRaftGroup(RaftGroup.valueOf((RaftGroupId)this.logServerGroupId, (RaftPeer[])new RaftPeer[]{peer})).build();
            try {
                client.groupRemove(raftGroup.getGroupId(), true, peer.getId());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        RaftClient client = RaftClient.newBuilder().setRaftGroup(this.currentGroup).setClientId(ClientId.randomId()).setProperties(this.properties).build();
        try {
            client.send(() -> MetaServiceProtos.MetaSMRequestProto.newBuilder().setUnregisterRequest(MetaServiceProtos.LogServiceUnregisterLogRequestProto.newBuilder().setLogname(LogServiceProtoUtil.toLogNameProto(logName))).build().toByteString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toDeleteLogReplyProto().toByteString()));
    }

    private CompletableFuture<Message> processArchiveLog(MetaServiceProtos.MetaServiceRequestProto logServiceRequestProto) {
        MetaServiceProtos.ArchiveLogRequestProto archiveLog = logServiceRequestProto.getArchiveLog();
        LogName logName = LogServiceProtoUtil.toLogName(archiveLog.getLogName());
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtos.ArchiveLogReplyProto.newBuilder().build().toByteString()));
    }

    private CompletableFuture<Message> processCreateLogRequest(MetaServiceProtos.MetaServiceRequestProto logServiceRequestProto) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            MetaServiceProtos.CreateLogRequestProto createLog = logServiceRequestProto.getCreateLog();
            LogName name = LogServiceProtoUtil.toLogName(createLog.getLogName());
            if (this.map.containsKey(name)) {
                CompletableFuture<Message> completableFuture = CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toCreateLogExceptionReplyProto(new LogAlreadyExistException(name.getName())).build().toByteString()));
                return completableFuture;
            }
            if (this.avail.size() < 3) {
                CompletableFuture<Message> completableFuture = CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toCreateLogExceptionReplyProto(new NoEnoughWorkersException(this.avail.size())).build().toByteString()));
                return completableFuture;
            }
            List peerGroup = IntStream.range(0, 3).mapToObj(i -> this.avail.poll()).collect(Collectors.toList());
            List<RaftPeer> peers = peerGroup.stream().map(obj -> obj.getPeer()).collect(Collectors.toList());
            RaftGroup raftGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), peers);
            peerGroup.stream().forEach(pg -> {
                pg.getGroups().add(raftGroup);
                this.avail.add((PeerGroups)pg);
            });
            peers.forEach(i -> {
                RaftClient client = RaftClient.newBuilder().setProperties(this.properties).setRaftGroup(RaftGroup.valueOf((RaftGroupId)this.logServerGroupId, (RaftPeer[])new RaftPeer[]{i})).build();
                try {
                    client.groupAdd(raftGroup, i.getId());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            RaftClient client = RaftClient.newBuilder().setRaftGroup(this.currentGroup).setClientId(ClientId.randomId()).setProperties(this.properties).build();
            try {
                client.send(() -> MetaServiceProtos.MetaSMRequestProto.newBuilder().setRegisterRequest(MetaServiceProtos.LogServiceRegisterLogRequestProto.newBuilder().setLogname(LogServiceProtoUtil.toLogNameProto(name)).setRaftGroup(MetaServiceProtoUtil.toRaftGroupProto(raftGroup))).build().toByteString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            CompletableFuture<Message> completableFuture = CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toCreateLogReplyProto(new LogInfo(name, raftGroup)).build().toByteString()));
            return completableFuture;
        }
    }

    private AutoCloseableLock writeLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.writeLock());
    }

    private CompletableFuture<Message> processListLogsRequest() {
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toListLogLogsReplyProto(this.map.entrySet().stream().map(log -> new LogInfo((LogName)log.getKey(), (RaftGroup)log.getValue())).collect(Collectors.toList())).toByteString()));
    }

    private CompletableFuture<Message> processGetLogRequest(MetaServiceProtos.MetaServiceRequestProto logServiceRequestProto) {
        MetaServiceProtos.GetLogRequestProto getLog = logServiceRequestProto.getGetLog();
        LogName logName = LogServiceProtoUtil.toLogName(getLog.getLogName());
        RaftGroup raftGroup = this.map.get(logName);
        if (raftGroup != null) {
            return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toGetLogReplyProto(new LogInfo(logName, raftGroup)).toByteString()));
        }
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)MetaServiceProtoUtil.toGetLogExceptionReplyProto(new LogNotFoundException(logName.getName())).build().toByteString()));
    }

    class PeerGroups
    implements Comparable {
        RaftPeer peer;
        Set<RaftGroup> groups = new HashSet<RaftGroup>();

        public PeerGroups(RaftPeer peer) {
            this.peer = peer;
        }

        public Set<RaftGroup> getGroups() {
            return this.groups;
        }

        public RaftPeer getPeer() {
            return this.peer;
        }

        public int compareTo(Object o) {
            return this.groups.size() - ((PeerGroups)o).groups.size();
        }
    }
}

