/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.proto.LogServiceProtos;
import org.apache.ratis.logservice.server.LogServiceRaftLogReader;
import org.apache.ratis.logservice.util.LogServiceProtoUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.ratis.thirdparty.com.google.protobuf.TextFormat;
import org.apache.ratis.util.AutoCloseableLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStateMachine
extends BaseStateMachine {
    public static final Logger LOG = LoggerFactory.getLogger(LogStateMachine.class);
    private long length;
    private long dataRecordsSize;
    private State state = State.OPEN;
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private RaftLog log;
    private RaftGroupId groupId;
    private RaftServerProxy proxy;

    private AutoCloseableLock readLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.readLock());
    }

    private AutoCloseableLock writeLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.writeLock());
    }

    void reset() {
        this.length = 0L;
        this.dataRecordsSize = 0L;
        this.setLastAppliedTermIndex(null);
    }

    public void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
        super.initialize(server, groupId, raftStorage);
        this.storage.init(raftStorage);
        this.proxy = (RaftServerProxy)server;
        this.groupId = groupId;
        this.loadSnapshot(this.storage.getLatestSnapshot());
    }

    private void checkInitialization() throws IOException {
        if (this.log == null) {
            ServerState state = this.proxy.getImpl(this.groupId).getState();
            this.log = state.getLog();
        }
    }

    public void reinitialize() throws IOException {
        this.close();
        this.loadSnapshot(this.storage.getLatestSnapshot());
    }

    public long takeSnapshot() {
        TermIndex last;
        try (AutoCloseableLock readLock = this.readLock();){
            last = this.getLastAppliedTermIndex();
        }
        File snapshotFile = this.storage.getSnapshotFile(last.getTerm(), last.getIndex());
        LOG.info("Taking a snapshot to file {}", (Object)snapshotFile);
        try (AutoCloseableLock readLock = this.readLock();
             ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(snapshotFile)));){
            out.writeLong(this.length);
            out.writeLong(this.dataRecordsSize);
            out.writeObject((Object)this.state);
        }
        catch (IOException ioe) {
            LOG.warn("Failed to write snapshot file \"" + snapshotFile + "\", last applied index=" + last);
        }
        return last.getIndex();
    }

    private long loadSnapshot(SingleFileSnapshotInfo snapshot) throws IOException {
        return this.load(snapshot, false);
    }

    private long load(SingleFileSnapshotInfo snapshot, boolean reload) throws IOException {
        if (snapshot == null) {
            LOG.warn("The snapshot info is null.");
            return -1L;
        }
        File snapshotFile = snapshot.getFile().getPath().toFile();
        if (!snapshotFile.exists()) {
            LOG.warn("The snapshot file {} does not exist for snapshot {}", (Object)snapshotFile, (Object)snapshot);
            return -1L;
        }
        TermIndex last = SimpleStateMachineStorage.getTermIndexFromSnapshotFile((File)snapshotFile);
        try (AutoCloseableLock writeLock = this.writeLock();
             ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(snapshotFile)));){
            if (reload) {
                this.reset();
            }
            this.setLastAppliedTermIndex(last);
            this.length = in.readLong();
            this.dataRecordsSize = in.readLong();
            this.state = (State)((Object)in.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return last.getIndex();
    }

    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    public CompletableFuture<Message> query(Message request) {
        try {
            this.checkInitialization();
            LogServiceProtos.LogServiceRequestProto logServiceRequestProto = LogServiceProtos.LogServiceRequestProto.parseFrom(request.getContent());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing LogService query: {}", (Object)TextFormat.shortDebugString((MessageOrBuilder)logServiceRequestProto));
            }
            switch (logServiceRequestProto.getRequestCase()) {
                case READNEXTQUERY: {
                    return this.processReadRequest(logServiceRequestProto);
                }
                case SIZEREQUEST: {
                    return this.processGetSizeRequest(logServiceRequestProto);
                }
                case STARTINDEXQUERY: {
                    return this.processGetStartIndexRequest(logServiceRequestProto);
                }
                case GETSTATE: {
                    return this.processGetStateRequest(logServiceRequestProto);
                }
                case LASTINDEXQUERY: {
                    return this.processGetLastCommittedIndexRequest(logServiceRequestProto);
                }
                case LENGTHQUERY: {
                    return this.processGetLengthRequest(logServiceRequestProto);
                }
            }
            throw new RuntimeException("Wrong message type for query: " + (Object)((Object)logServiceRequestProto.getRequestCase()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<Message> processGetStartIndexRequest(LogServiceProtos.LogServiceRequestProto proto) {
        Throwable t = this.verifyState(State.OPEN);
        long startIndex = this.log.getStartIndex();
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLogStartIndexReplyProto(startIndex, t).toByteString()));
    }

    private CompletableFuture<Message> processGetLastCommittedIndexRequest(LogServiceProtos.LogServiceRequestProto proto) {
        Throwable t = this.verifyState(State.OPEN);
        long lastIndex = this.log.getLastCommittedIndex();
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLogLastIndexReplyProto(lastIndex, t).toByteString()));
    }

    private CompletableFuture<Message> processGetSizeRequest(LogServiceProtos.LogServiceRequestProto proto) {
        LogServiceProtos.GetLogSizeRequestProto msgProto = proto.getSizeRequest();
        Throwable t = this.verifyState(State.OPEN);
        LOG.debug("QUERY: {}, RESULT: {}", (Object)msgProto, (Object)this.dataRecordsSize);
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLogSizeReplyProto(this.dataRecordsSize, t).toByteString()));
    }

    private CompletableFuture<Message> processGetLengthRequest(LogServiceProtos.LogServiceRequestProto proto) {
        LogServiceProtos.GetLogLengthRequestProto msgProto = proto.getLengthQuery();
        Throwable t = this.verifyState(State.OPEN);
        LOG.debug("QUERY: {}, RESULT: {}", (Object)msgProto, (Object)this.length);
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetLogLengthReplyProto(this.length, t).toByteString()));
    }

    private CompletableFuture<Message> processReadRequest(LogServiceProtos.LogServiceRequestProto proto) {
        LogServiceProtos.ReadLogRequestProto msgProto = proto.getReadNextQuery();
        long startRecordId = msgProto.getStartRecordId();
        int numRecordsToRead = msgProto.getNumRecords();
        Throwable t = this.verifyState(State.OPEN);
        ArrayList<byte[]> list = null;
        if (t == null) {
            LogServiceRaftLogReader reader = new LogServiceRaftLogReader(this.log);
            list = new ArrayList<byte[]>();
            try {
                reader.seek(startRecordId);
                for (int i = 0; i < numRecordsToRead && reader.hasNext(); ++i) {
                    list.add(reader.next().toByteArray());
                }
            }
            catch (Exception e) {
                LOG.error("Failed to execute ReadNextQuery", (Throwable)e);
                t = e;
                list = null;
            }
        }
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toReadLogReplyProto(list, t).toByteString()));
    }

    private CompletableFuture<Message> processSyncRequest(TransactionContext trx, LogServiceProtos.LogServiceRequestProto logMessage) {
        long index = trx.getLogEntry().getIndex();
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toSyncLogReplyProto(index, null).toByteString()));
    }

    private CompletableFuture<Message> processAppendRequest(TransactionContext trx, LogServiceProtos.LogServiceRequestProto logProto) {
        RaftProtos.LogEntryProto entry = trx.getLogEntry();
        LogServiceProtos.AppendLogEntryRequestProto proto = logProto.getAppendRequest();
        long index = entry.getIndex();
        long newSize = 0L;
        Throwable t = this.verifyState(State.OPEN);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (t == null) {
            try (AutoCloseableLock writeLock = this.writeLock();){
                List<byte[]> entries = LogServiceProtoUtil.toListByteArray(proto.getDataList());
                for (byte[] bb : entries) {
                    ids.add(this.length);
                    newSize += (long)bb.length;
                    ++this.length;
                }
                this.dataRecordsSize += newSize;
                this.updateLastAppliedTermIndex(entry.getTerm(), index);
            }
        }
        CompletableFuture<Message> f = CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toAppendLogReplyProto(ids, t).toByteString()));
        RaftProtos.RaftPeerRole role = trx.getServerRole();
        LOG.debug("{}:{}-{}: {} new length {}", new Object[]{role, this.getId(), index, proto, this.dataRecordsSize});
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}-{}: variables={}", new Object[]{this.getId(), index, this.dataRecordsSize});
        }
        return f;
    }

    public void close() {
        this.reset();
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        try {
            this.checkInitialization();
            RaftProtos.LogEntryProto entry = trx.getLogEntry();
            LogServiceProtos.LogServiceRequestProto logServiceRequestProto = LogServiceProtos.LogServiceRequestProto.parseFrom(entry.getStateMachineLogEntry().getLogData());
            switch (logServiceRequestProto.getRequestCase()) {
                case CLOSELOG: {
                    return this.processCloseLog(logServiceRequestProto);
                }
                case APPENDREQUEST: {
                    return this.processAppendRequest(trx, logServiceRequestProto);
                }
                case SYNCREQUEST: {
                    return this.processSyncRequest(trx, logServiceRequestProto);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CompletableFuture<Message> processCloseLog(LogServiceProtos.LogServiceRequestProto logServiceRequestProto) {
        LogServiceProtos.CloseLogRequestProto closeLog = logServiceRequestProto.getCloseLog();
        LogName logName = LogServiceProtoUtil.toLogName(closeLog.getLogName());
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtos.CloseLogReplyProto.newBuilder().build().toByteString()));
    }

    private CompletableFuture<Message> processGetStateRequest(LogServiceProtos.LogServiceRequestProto logServiceRequestProto) {
        LogServiceProtos.GetStateRequestProto getState = logServiceRequestProto.getGetState();
        LogName logName = LogServiceProtoUtil.toLogName(getState.getLogName());
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)LogServiceProtoUtil.toGetStateReplyProto(this.state == State.OPEN).toByteString()));
    }

    private Throwable verifyState(State state) {
        if (this.state != state) {
            return new IOException("Wrong state: " + (Object)((Object)this.state));
        }
        return null;
    }

    public static enum State {
        OPEN,
        CLOSED;

    }
}

