/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.logservice.server.BaseServer;
import org.apache.ratis.logservice.server.LogStateMachine;
import org.apache.ratis.logservice.server.ManagementStateMachine;
import org.apache.ratis.logservice.server.ServerOpts;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.logservice.util.MetaServiceProtoUtil;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.statemachine.StateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServer
extends BaseServer {
    private static final Logger LOG = LoggerFactory.getLogger(LogServer.class);
    private RaftServer raftServer = null;
    private RaftClient metaClient = null;

    public LogServer(ServerOpts opts) {
        super(opts);
    }

    public RaftServer getServer() {
        return this.raftServer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void start() throws IOException {
        ServerOpts opts = this.getServerOpts();
        Set<RaftPeer> peers = LogServiceUtils.getPeersFromQuorum(opts.getMetaQuorum());
        RaftProperties properties = new RaftProperties();
        properties.set("raft.client.rpc.request.timeout", "100000");
        GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)opts.getPort());
        NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)opts.getPort());
        InetSocketAddress addr = new InetSocketAddress(opts.getHost(), opts.getPort());
        if (opts.getWorkingDir() != null) {
            RaftServerConfigKeys.setStorageDirs((RaftProperties)properties, Collections.singletonList(new File(opts.getWorkingDir())));
        }
        String id = opts.getHost() + "_" + opts.getPort();
        RaftPeer peer = new RaftPeer(RaftPeerId.valueOf((String)id), addr);
        final RaftGroupId logServerGroupId = RaftGroupId.valueOf((UUID)opts.getLogServerGroupId());
        RaftGroup all = RaftGroup.valueOf((RaftGroupId)logServerGroupId, (RaftPeer[])new RaftPeer[]{peer});
        RaftGroup meta = RaftGroup.valueOf((RaftGroupId)RaftGroupId.valueOf((UUID)opts.getMetaGroupId()), peers);
        this.raftServer = RaftServer.newBuilder().setStateMachineRegistry(new StateMachine.Registry(){

            public StateMachine apply(RaftGroupId raftGroupId) {
                if (raftGroupId.equals((Object)logServerGroupId)) {
                    return new ManagementStateMachine();
                }
                return new LogStateMachine();
            }
        }).setProperties(properties).setServerId(RaftPeerId.valueOf((String)id)).setGroup(all).build();
        this.raftServer.start();
        this.metaClient = RaftClient.newBuilder().setRaftGroup(meta).setClientId(ClientId.randomId()).setProperties(properties).build();
        this.metaClient.send(() -> MetaServiceProtoUtil.toPingRequestProto(peer).toByteString());
    }

    public static void main(String[] args) throws IOException {
        ServerOpts opts = new ServerOpts();
        JCommander.newBuilder().addObject((Object)opts).build().parse(args);
        try (LogServer worker = new LogServer(opts);){
            worker.start();
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.raftServer.close();
    }

    public static class Builder
    extends BaseServer.Builder<LogServer> {
        @Override
        public LogServer build() {
            this.validate();
            return new LogServer(this.getOpts());
        }
    }
}

