/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.server;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.ratis.logservice.server.ServerOpts;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.util.NetUtils;

public abstract class BaseServer
implements Closeable {
    private final ServerOpts opts;

    public BaseServer(ServerOpts opts) {
        this.opts = Objects.requireNonNull(opts);
    }

    public ServerOpts getServerOpts() {
        return this.opts;
    }

    static ServerOpts buildOpts(String hostname, String metaQuorum, int port, String workingDir) {
        ServerOpts opts = new ServerOpts();
        opts.setHost(hostname);
        opts.setMetaQuorum(metaQuorum);
        opts.setPort(port);
        opts.setWorkingDir(workingDir);
        return opts;
    }

    public static abstract class Builder<T extends BaseServer> {
        private ServerOpts opts = new ServerOpts();

        protected ServerOpts getOpts() {
            return this.opts;
        }

        public abstract T build();

        public Builder<T> validate() {
            if (this.opts.getPort() == -1) {
                InetSocketAddress addr = NetUtils.createLocalServerAddress();
                this.opts.setPort(addr.getPort());
            }
            if (this.opts.getHost() == null) {
                this.opts.setHost(LogServiceUtils.getHostName());
            }
            if (this.opts.getWorkingDir() == null) {
                throw new IllegalArgumentException("Working directory was not specified");
            }
            return this;
        }

        public Builder<T> setMetaQuorum(String meta) {
            this.opts.setMetaQuorum(meta);
            return this;
        }

        public Builder<T> setPort(int port) {
            this.opts.setPort(port);
            return this;
        }

        public Builder<T> setWorkingDir(String workingDir) {
            this.opts.setWorkingDir(workingDir);
            return this;
        }

        public Builder<T> setHostName(String hostName) {
            this.opts.setHost(hostName);
            return this;
        }
    }
}

