/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.logservice.client;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.logservice.api.LogInfo;
import org.apache.ratis.logservice.api.LogName;
import org.apache.ratis.logservice.api.LogServiceConfiguration;
import org.apache.ratis.logservice.api.LogStream;
import org.apache.ratis.logservice.common.Constants;
import org.apache.ratis.logservice.impl.LogStreamImpl;
import org.apache.ratis.logservice.proto.MetaServiceProtos;
import org.apache.ratis.logservice.util.LogServiceUtils;
import org.apache.ratis.logservice.util.MetaServiceProtoUtil;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;

public class LogServiceClient
implements AutoCloseable {
    private final RaftClient client;
    private final LogServiceConfiguration config;

    public LogServiceClient(String metaQuorum) {
        this(metaQuorum, new LogServiceConfiguration());
    }

    public LogServiceClient(String metaQuorum, LogServiceConfiguration config) {
        Set<RaftPeer> peers = LogServiceUtils.getPeersFromQuorum(metaQuorum);
        RaftProperties properties = new RaftProperties();
        RaftGroup meta = RaftGroup.valueOf((RaftGroupId)Constants.META_GROUP_ID, peers);
        this.client = RaftClient.newBuilder().setRaftGroup(meta).setClientId(ClientId.randomId()).setProperties(properties).build();
        this.config = config;
    }

    public LogStream createLog(LogName logName) throws IOException {
        RaftClientReply reply = this.client.sendReadOnly(() -> MetaServiceProtoUtil.toCreateLogRequestProto(logName).toByteString());
        MetaServiceProtos.CreateLogReplyProto message = MetaServiceProtos.CreateLogReplyProto.parseFrom(reply.getMessage().getContent());
        if (message.hasException()) {
            throw MetaServiceProtoUtil.toMetaServiceException(message.getException());
        }
        LogInfo info = MetaServiceProtoUtil.toLogInfo(message.getLog());
        return new LogStreamImpl(logName, this.getRaftClient(info), this.config);
    }

    public LogStream getLog(LogName logName) throws IOException {
        RaftClientReply reply = this.client.sendReadOnly(() -> MetaServiceProtoUtil.toGetLogRequestProto(logName).toByteString());
        MetaServiceProtos.GetLogReplyProto message = MetaServiceProtos.GetLogReplyProto.parseFrom(reply.getMessage().getContent());
        if (message.hasException()) {
            throw MetaServiceProtoUtil.toMetaServiceException(message.getException());
        }
        LogInfo info = MetaServiceProtoUtil.toLogInfo(message.getLog());
        return new LogStreamImpl(logName, this.getRaftClient(info), this.config);
    }

    public void deleteLog(LogName logName) throws IOException {
        RaftClientReply reply = this.client.sendReadOnly(() -> MetaServiceProtoUtil.toDeleteLogRequestProto(logName).toByteString());
        MetaServiceProtos.DeleteLogReplyProto message = MetaServiceProtos.DeleteLogReplyProto.parseFrom(reply.getMessage().getContent());
        if (message.hasException()) {
            throw MetaServiceProtoUtil.toMetaServiceException(message.getException());
        }
    }

    public List<LogInfo> listLogs() throws IOException {
        RaftClientReply reply = this.client.sendReadOnly(() -> MetaServiceProtoUtil.toListLogRequestProto().toByteString());
        MetaServiceProtos.ListLogsReplyProto message = MetaServiceProtos.ListLogsReplyProto.parseFrom(reply.getMessage().getContent());
        List<MetaServiceProtos.LogInfoProto> infoProtos = message.getLogsList();
        List<LogInfo> infos = infoProtos.stream().map(proto -> MetaServiceProtoUtil.toLogInfo(proto)).collect(Collectors.toList());
        return infos;
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    private RaftClient getRaftClient(LogInfo logInfo) {
        RaftProperties properties = new RaftProperties();
        return RaftClient.newBuilder().setRaftGroup(logInfo.getRaftGroup()).setProperties(properties).build();
    }

    void archiveLog(LogName name) throws IOException {
    }

    void closeLog(LogName name) throws IOException {
    }

    void updateConfiguration(LogName name, LogServiceConfiguration config) {
    }
}

