/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServerProtocolService
extends RaftServerProtocolServiceGrpc.RaftServerProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcServerProtocolService.class);
    private final Supplier<RaftPeerId> idSupplier;
    private final RaftServer server;

    public GrpcServerProtocolService(Supplier<RaftPeerId> idSupplier, RaftServer server) {
        this.idSupplier = idSupplier;
        this.server = server;
    }

    RaftPeerId getId() {
        return this.idSupplier.get();
    }

    public void requestVote(RaftProtos.RequestVoteRequestProto request, StreamObserver<RaftProtos.RequestVoteReplyProto> responseObserver) {
        try {
            RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable e) {
            GrpcUtil.warn(LOG, () -> this.getId() + ": Failed requestVote " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
            responseObserver.onError((Throwable)GrpcUtil.wrapException(e));
        }
    }

    public StreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(final StreamObserver<RaftProtos.AppendEntriesReplyProto> responseObserver) {
        return new StreamObserver<RaftProtos.AppendEntriesRequestProto>(){
            private final AtomicReference<CompletableFuture<Void>> previousOnNext = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));
            private final AtomicBoolean isClosed = new AtomicBoolean(false);

            public void onNext(RaftProtos.AppendEntriesRequestProto request) {
                CompletableFuture current = new CompletableFuture();
                CompletableFuture previous = this.previousOnNext.getAndSet(current);
                try {
                    GrpcServerProtocolService.this.server.appendEntriesAsync(request).thenCombine((CompletionStage)previous, (reply, v) -> {
                        if (!this.isClosed.get()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(GrpcServerProtocolService.this.server.getId() + ": reply " + ServerProtoUtils.toString((RaftProtos.AppendEntriesReplyProto)reply));
                            }
                            responseObserver.onNext(reply);
                        }
                        current.complete(null);
                        return null;
                    });
                }
                catch (Throwable e) {
                    GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": Failed appendEntries " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
                    responseObserver.onError((Throwable)GrpcUtil.wrapException(e, request.getServerRequest().getCallId()));
                    current.completeExceptionally(e);
                }
            }

            public void onError(Throwable t) {
                GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": appendEntries onError", t);
            }

            public void onCompleted() {
                if (this.isClosed.compareAndSet(false, true)) {
                    LOG.info("{}: appendEntries completed", (Object)GrpcServerProtocolService.this.getId());
                    responseObserver.onCompleted();
                }
            }
        };
    }

    public StreamObserver<RaftProtos.InstallSnapshotRequestProto> installSnapshot(final StreamObserver<RaftProtos.InstallSnapshotReplyProto> responseObserver) {
        return new StreamObserver<RaftProtos.InstallSnapshotRequestProto>(){

            public void onNext(RaftProtos.InstallSnapshotRequestProto request) {
                try {
                    RaftProtos.InstallSnapshotReplyProto reply = GrpcServerProtocolService.this.server.installSnapshot(request);
                    responseObserver.onNext((Object)reply);
                }
                catch (Throwable e) {
                    GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": Failed installSnapshot " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
                    responseObserver.onError((Throwable)GrpcUtil.wrapException(e));
                }
            }

            public void onError(Throwable t) {
                GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": installSnapshot onError", t);
            }

            public void onCompleted() {
                LOG.info("{}: installSnapshot completed", (Object)GrpcServerProtocolService.this.getId());
                responseObserver.onCompleted();
            }
        };
    }
}

