/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.AdminProtocolServiceGrpc;
import org.apache.ratis.proto.grpc.RaftClientProtocolServiceGrpc;
import org.apache.ratis.protocol.AlreadyClosedException;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.TimeoutIOException;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NegotiationType;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientProtocolClient
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcClientProtocolClient.class);
    private final Supplier<String> name;
    private final RaftPeer target;
    private final ManagedChannel channel;
    private final TimeDuration requestTimeoutDuration;
    private final TimeoutScheduler scheduler = TimeoutScheduler.newInstance((int)3);
    private final RaftClientProtocolServiceGrpc.RaftClientProtocolServiceBlockingStub blockingStub;
    private final RaftClientProtocolServiceGrpc.RaftClientProtocolServiceStub asyncStub;
    private final AdminProtocolServiceGrpc.AdminProtocolServiceBlockingStub adminBlockingStub;
    private final AtomicReference<AsyncStreamObservers> orderedStreamObservers = new AtomicReference();
    private final AtomicReference<AsyncStreamObservers> unorderedStreamObservers = new AtomicReference();

    GrpcClientProtocolClient(ClientId id, RaftPeer target, RaftProperties properties, GrpcTlsConfig tlsConf) {
        this.name = JavaUtils.memoize(() -> id + "->" + target.getId());
        this.target = target;
        SizeInBytes flowControlWindow = GrpcConfigKeys.flowControlWindow(properties, arg_0 -> ((Logger)LOG).debug(arg_0));
        SizeInBytes maxMessageSize = GrpcConfigKeys.messageSizeMax(properties, arg_0 -> ((Logger)LOG).debug(arg_0));
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)target.getAddress());
        if (tlsConf != null) {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (tlsConf.getTrustStore() != null) {
                sslContextBuilder.trustManager(tlsConf.getTrustStore());
            }
            if (tlsConf.getMtlsEnabled()) {
                sslContextBuilder.keyManager(tlsConf.getCertChain(), tlsConf.getPrivateKey());
            }
            try {
                channelBuilder.useTransportSecurity().sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        this.channel = ((NettyChannelBuilder)channelBuilder.flowControlWindow(flowControlWindow.getSizeInt()).maxInboundMessageSize(maxMessageSize.getSizeInt())).build();
        this.blockingStub = RaftClientProtocolServiceGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = RaftClientProtocolServiceGrpc.newStub((Channel)this.channel);
        this.adminBlockingStub = AdminProtocolServiceGrpc.newBlockingStub((Channel)this.channel);
        this.requestTimeoutDuration = RaftClientConfigKeys.Rpc.requestTimeout((RaftProperties)properties);
    }

    String getName() {
        return this.name.get();
    }

    @Override
    public void close() {
        Optional.ofNullable(this.orderedStreamObservers.getAndSet(null)).ifPresent(rec$ -> ((AsyncStreamObservers)rec$).close());
        Optional.ofNullable(this.unorderedStreamObservers.getAndSet(null)).ifPresent(rec$ -> ((AsyncStreamObservers)rec$).close());
        this.channel.shutdownNow();
    }

    RaftProtos.RaftClientReplyProto groupAdd(RaftProtos.GroupManagementRequestProto request) throws IOException {
        return GrpcClientProtocolClient.blockingCall((CheckedSupplier<RaftProtos.RaftClientReplyProto, StatusRuntimeException>)((CheckedSupplier)() -> ((AdminProtocolServiceGrpc.AdminProtocolServiceBlockingStub)this.adminBlockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).groupManagement(request)));
    }

    RaftProtos.GroupListReplyProto groupList(RaftProtos.GroupListRequestProto request) {
        return ((AdminProtocolServiceGrpc.AdminProtocolServiceBlockingStub)this.adminBlockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).groupList(request);
    }

    RaftProtos.GroupInfoReplyProto groupInfo(RaftProtos.GroupInfoRequestProto request) {
        return ((AdminProtocolServiceGrpc.AdminProtocolServiceBlockingStub)this.adminBlockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).groupInfo(request);
    }

    RaftProtos.RaftClientReplyProto setConfiguration(RaftProtos.SetConfigurationRequestProto request) throws IOException {
        return GrpcClientProtocolClient.blockingCall((CheckedSupplier<RaftProtos.RaftClientReplyProto, StatusRuntimeException>)((CheckedSupplier)() -> ((RaftClientProtocolServiceGrpc.RaftClientProtocolServiceBlockingStub)this.blockingStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).setConfiguration(request)));
    }

    private static RaftProtos.RaftClientReplyProto blockingCall(CheckedSupplier<RaftProtos.RaftClientReplyProto, StatusRuntimeException> supplier) throws IOException {
        try {
            return (RaftProtos.RaftClientReplyProto)supplier.get();
        }
        catch (StatusRuntimeException e) {
            throw GrpcUtil.unwrapException(e);
        }
    }

    StreamObserver<RaftProtos.RaftClientRequestProto> ordered(StreamObserver<RaftProtos.RaftClientReplyProto> responseHandler) {
        return this.asyncStub.ordered(responseHandler);
    }

    StreamObserver<RaftProtos.RaftClientRequestProto> orderedWithTimeout(StreamObserver<RaftProtos.RaftClientReplyProto> responseHandler) {
        return ((RaftClientProtocolServiceGrpc.RaftClientProtocolServiceStub)this.asyncStub.withDeadlineAfter(this.requestTimeoutDuration.getDuration(), this.requestTimeoutDuration.getUnit())).unordered(responseHandler);
    }

    AsyncStreamObservers getOrderedStreamObservers() {
        return this.orderedStreamObservers.updateAndGet(a -> a != null ? a : new AsyncStreamObservers(this.orderedStreamObservers, this::ordered));
    }

    AsyncStreamObservers getUnorderedAsyncStreamObservers() {
        return this.unorderedStreamObservers.updateAndGet(a -> a != null ? a : new AsyncStreamObservers(this.unorderedStreamObservers, arg_0 -> ((RaftClientProtocolServiceGrpc.RaftClientProtocolServiceStub)this.asyncStub).unordered(arg_0)));
    }

    public RaftPeer getTarget() {
        return this.target;
    }

    class AsyncStreamObservers {
        private final ReplyMap replies;
        private final StreamObserver<RaftProtos.RaftClientReplyProto> replyStreamObserver;
        private final RequestStreamer requestStreamer;
        private final AtomicReference<AsyncStreamObservers> ref;

        AsyncStreamObservers(AtomicReference<AsyncStreamObservers> ref, Function<StreamObserver<RaftProtos.RaftClientReplyProto>, StreamObserver<RaftProtos.RaftClientRequestProto>> f) {
            this.replies = new ReplyMap();
            this.replyStreamObserver = new StreamObserver<RaftProtos.RaftClientReplyProto>(){

                public void onNext(RaftProtos.RaftClientReplyProto proto) {
                    long callId = proto.getRpcReply().getCallId();
                    try {
                        RaftClientReply reply = ClientProtoUtils.toRaftClientReply((RaftProtos.RaftClientReplyProto)proto);
                        LOG.info("{}: receive {}", (Object)GrpcClientProtocolClient.this.getName(), (Object)reply);
                        NotLeaderException nle = reply.getNotLeaderException();
                        if (nle != null) {
                            AsyncStreamObservers.this.completeReplyExceptionally((Throwable)nle, NotLeaderException.class.getName());
                            return;
                        }
                        AsyncStreamObservers.this.handleReplyFuture(callId, f -> f.complete(reply));
                    }
                    catch (Throwable t) {
                        AsyncStreamObservers.this.handleReplyFuture(callId, f -> f.completeExceptionally(t));
                    }
                }

                public void onError(Throwable t) {
                    IOException ioe = GrpcUtil.unwrapIOException(t);
                    AsyncStreamObservers.this.completeReplyExceptionally(ioe, "onError");
                }

                public void onCompleted() {
                    AsyncStreamObservers.this.completeReplyExceptionally(null, "completed");
                }
            };
            this.requestStreamer = new RequestStreamer(f.apply(this.replyStreamObserver));
            this.ref = ref;
        }

        CompletableFuture<RaftClientReply> onNext(RaftClientRequest request) {
            CompletableFuture<RaftClientReply> f = this.replies.putNew(request.getCallId());
            if (f == null) {
                return JavaUtils.completeExceptionally((Throwable)new AlreadyClosedException(GrpcClientProtocolClient.this.getName() + " is closed."));
            }
            try {
                if (!this.requestStreamer.onNext(ClientProtoUtils.toRaftClientRequestProto((RaftClientRequest)request))) {
                    throw new AlreadyClosedException(GrpcClientProtocolClient.this.getName() + ": the stream is closed.");
                }
            }
            catch (Throwable t) {
                this.handleReplyFuture(request.getCallId(), future -> future.completeExceptionally(t));
                return f;
            }
            GrpcClientProtocolClient.this.scheduler.onTimeout(GrpcClientProtocolClient.this.requestTimeoutDuration, () -> this.timeoutCheck(request), LOG, () -> "Timeout check failed for client request: " + request);
            return f;
        }

        private void timeoutCheck(RaftClientRequest request) {
            this.handleReplyFuture(request.getCallId(), f -> f.completeExceptionally((Throwable)new TimeoutIOException("Request timeout " + GrpcClientProtocolClient.this.requestTimeoutDuration + ": " + request)));
        }

        private void handleReplyFuture(long callId, Consumer<CompletableFuture<RaftClientReply>> handler) {
            this.replies.remove(callId).ifPresent(handler);
        }

        private void close() {
            this.requestStreamer.onCompleted();
            this.completeReplyExceptionally(null, "close");
        }

        private void completeReplyExceptionally(Throwable t, String event) {
            this.ref.compareAndSet(this, null);
            Map<Long, CompletableFuture<RaftClientReply>> map = this.replies.getAndSetNull();
            if (map == null) {
                return;
            }
            for (Map.Entry<Long, CompletableFuture<RaftClientReply>> entry : map.entrySet()) {
                CompletableFuture<RaftClientReply> f = entry.getValue();
                if (f.isDone()) continue;
                f.completeExceptionally(t != null ? t : new AlreadyClosedException(GrpcClientProtocolClient.this.getName() + ": Stream " + event + ": no reply for async request cid=" + entry.getKey()));
            }
        }
    }

    static class RequestStreamer {
        private final AtomicReference<StreamObserver<RaftProtos.RaftClientRequestProto>> streamObserver;

        RequestStreamer(StreamObserver<RaftProtos.RaftClientRequestProto> streamObserver) {
            this.streamObserver = new AtomicReference<StreamObserver<RaftProtos.RaftClientRequestProto>>(streamObserver);
        }

        synchronized boolean onNext(RaftProtos.RaftClientRequestProto request) {
            StreamObserver<RaftProtos.RaftClientRequestProto> s = this.streamObserver.get();
            if (s != null) {
                s.onNext((Object)request);
                return true;
            }
            return false;
        }

        synchronized void onCompleted() {
            StreamObserver s = this.streamObserver.getAndSet(null);
            if (s != null) {
                s.onCompleted();
            }
        }
    }

    class ReplyMap {
        private final AtomicReference<Map<Long, CompletableFuture<RaftClientReply>>> map = new AtomicReference(new ConcurrentHashMap());

        ReplyMap() {
        }

        synchronized CompletableFuture<RaftClientReply> putNew(long callId) {
            return Optional.ofNullable(this.map.get()).map(m -> (CompletableFuture)CollectionUtils.putNew((Object)callId, new CompletableFuture(), (Map)m, this::toString)).orElse(null);
        }

        Optional<CompletableFuture<RaftClientReply>> remove(long callId) {
            return Optional.ofNullable(this.map.get()).map(m -> (CompletableFuture)m.remove(callId));
        }

        synchronized Map<Long, CompletableFuture<RaftClientReply>> getAndSetNull() {
            return this.map.getAndSet(null);
        }

        public String toString() {
            return GrpcClientProtocolClient.this.getName() + ":" + this.getClass().getSimpleName();
        }
    }
}

