/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.conf;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ratis.thirdparty.com.google.common.base.Objects;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedBiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ConfUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ConfUtils.class);

    public static <T> void logGet(String key, T value, T defaultValue, Consumer<String> logger) {
        if (logger != null) {
            logger.accept(String.format("%s = %s (%s)", key, value, Objects.equal(value, defaultValue) ? "default" : "custom"));
        }
    }

    public static void logSet(String key, Object value) {
        LOG.debug("set {} = {}", (Object)key, value);
    }

    public static BiConsumer<String, Integer> requireMin(int min) {
        return (key, value) -> {
            if (value < min) {
                throw new IllegalArgumentException(key + " = " + value + " < min = " + min);
            }
        };
    }

    public static BiConsumer<String, Integer> requireMax(int max) {
        return (key, value) -> {
            if (value > max) {
                throw new IllegalArgumentException(key + " = " + value + " > max = " + max);
            }
        };
    }

    public static BiConsumer<String, Long> requireMin(long min) {
        return (key, value) -> {
            if (value < min) {
                throw new IllegalArgumentException(key + " = " + value + " < min = " + min);
            }
        };
    }

    public static BiConsumer<String, Long> requireMax(long max) {
        return (key, value) -> {
            if (value > max) {
                throw new IllegalArgumentException(key + " = " + value + " > max = " + max);
            }
        };
    }

    public static BiConsumer<String, TimeDuration> requireNonNegativeTimeDuration() {
        return (key, value) -> {
            if (value.isNegative()) {
                throw new IllegalArgumentException(key + " = " + value + " is negative.");
            }
        };
    }

    public static BiConsumer<String, TimeDuration> requirePositive() {
        return (key, value) -> {
            if (value.getDuration() <= 0L) {
                throw new IllegalArgumentException(key + " = " + value + " is non-positive.");
            }
        };
    }

    public static BiFunction<String, Long, Integer> requireInt() {
        return (key, value) -> {
            try {
                return Math.toIntExact(value);
            }
            catch (ArithmeticException ae) {
                throw new IllegalArgumentException("Failed to cast " + key + " = " + value + " to int.", ae);
            }
        };
    }

    @SafeVarargs
    public static boolean getBoolean(BiFunction<String, Boolean, Boolean> booleanGetter, String key, boolean defaultValue, Consumer<String> logger, BiConsumer<String, Boolean> ... assertions) {
        return ConfUtils.get(booleanGetter, key, defaultValue, logger, assertions);
    }

    @SafeVarargs
    public static int getInt(BiFunction<String, Integer, Integer> integerGetter, String key, int defaultValue, Consumer<String> logger, BiConsumer<String, Integer> ... assertions) {
        return ConfUtils.get(integerGetter, key, defaultValue, logger, assertions);
    }

    @SafeVarargs
    public static long getLong(BiFunction<String, Long, Long> longGetter, String key, long defaultValue, Consumer<String> logger, BiConsumer<String, Long> ... assertions) {
        return ConfUtils.get(longGetter, key, defaultValue, logger, assertions);
    }

    @SafeVarargs
    public static File getFile(BiFunction<String, File, File> fileGetter, String key, File defaultValue, Consumer<String> logger, BiConsumer<String, File> ... assertions) {
        return ConfUtils.get(fileGetter, key, defaultValue, logger, assertions);
    }

    @SafeVarargs
    public static List<File> getFiles(BiFunction<String, List<File>, List<File>> fileGetter, String key, List<File> defaultValue, Consumer<String> logger, BiConsumer<String, List<File>> ... assertions) {
        return ConfUtils.get(fileGetter, key, defaultValue, logger, assertions);
    }

    @SafeVarargs
    public static SizeInBytes getSizeInBytes(BiFunction<String, SizeInBytes, SizeInBytes> getter, String key, SizeInBytes defaultValue, Consumer<String> logger, BiConsumer<String, SizeInBytes> ... assertions) {
        SizeInBytes value = ConfUtils.get(getter, key, defaultValue, logger, assertions);
        ConfUtils.requireMin(0L).accept(key, value.getSize());
        return value;
    }

    @SafeVarargs
    public static TimeDuration getTimeDuration(BiFunction<String, TimeDuration, TimeDuration> getter, String key, TimeDuration defaultValue, Consumer<String> logger, BiConsumer<String, TimeDuration> ... assertions) {
        TimeDuration value = ConfUtils.get(getter, key, defaultValue, logger, assertions);
        ConfUtils.requireNonNegativeTimeDuration().accept(key, value);
        return value;
    }

    @SafeVarargs
    public static <T> T get(BiFunction<String, T, T> getter, String key, T defaultValue, Consumer<String> logger, BiConsumer<String, T> ... assertions) {
        Object value = getter.apply(key, (String)defaultValue);
        ConfUtils.logGet(key, value, defaultValue, logger);
        Arrays.asList(assertions).forEach(a -> a.accept(key, value));
        return value;
    }

    public static InetSocketAddress getInetSocketAddress(BiFunction<String, String, String> stringGetter, String key, String defaultValue, Consumer<String> logger) {
        return NetUtils.createSocketAddr(ConfUtils.get(stringGetter, key, defaultValue, logger, new BiConsumer[0]));
    }

    @SafeVarargs
    public static void setBoolean(BiConsumer<String, Boolean> booleanSetter, String key, boolean value, BiConsumer<String, Boolean> ... assertions) {
        ConfUtils.set(booleanSetter, key, value, assertions);
    }

    @SafeVarargs
    public static void setInt(BiConsumer<String, Integer> integerSetter, String key, int value, BiConsumer<String, Integer> ... assertions) {
        ConfUtils.set(integerSetter, key, value, assertions);
    }

    @SafeVarargs
    public static void setLong(BiConsumer<String, Long> longSetter, String key, long value, BiConsumer<String, Long> ... assertions) {
        ConfUtils.set(longSetter, key, value, assertions);
    }

    @SafeVarargs
    public static void setFile(BiConsumer<String, File> fileSetter, String key, File value, BiConsumer<String, File> ... assertions) {
        ConfUtils.set(fileSetter, key, value, assertions);
    }

    @SafeVarargs
    public static void setFiles(BiConsumer<String, List<File>> fileSetter, String key, List<File> value, BiConsumer<String, List<File>> ... assertions) {
        ConfUtils.set(fileSetter, key, value, assertions);
    }

    @SafeVarargs
    public static void setSizeInBytes(BiConsumer<String, String> stringSetter, String key, SizeInBytes value, BiConsumer<String, Long> ... assertions) {
        long v = value.getSize();
        Arrays.asList(assertions).forEach(a -> a.accept(key, v));
        ConfUtils.set(stringSetter, key, value.getInput(), new BiConsumer[0]);
    }

    @SafeVarargs
    public static void setTimeDuration(BiConsumer<String, TimeDuration> timeDurationSetter, String key, TimeDuration value, BiConsumer<String, TimeDuration> ... assertions) {
        ConfUtils.set(timeDurationSetter, key, value, assertions);
    }

    @SafeVarargs
    public static <T> void set(BiConsumer<String, T> setter, String key, T value, BiConsumer<String, T> ... assertions) {
        Arrays.asList(assertions).forEach(a -> a.accept(key, value));
        setter.accept(key, (String)value);
        ConfUtils.logSet(key, value);
    }

    public static void printAll(Class<?> confClass) {
        ConfUtils.printAll(confClass, System.out::println);
    }

    public static void printAll(Class<?> confClass, Consumer<Object> out) {
        out.accept("");
        out.accept("******* " + confClass + " *******");
        Arrays.asList(confClass.getDeclaredFields()).forEach(f -> ConfUtils.printField(confClass, out, f));
        Arrays.asList(confClass.getClasses()).forEach(c -> ConfUtils.printAll(c, s -> out.accept("  " + s)));
    }

    public static void printField(Class<?> confClass, Consumer<Object> out, Field f) {
        if (!Modifier.isStatic(f.getModifiers())) {
            out.accept("WARNING: Found non-static field " + f);
            return;
        }
        if (ConfUtils.printKey(confClass, out, f, "KEY", "DEFAULT", (b, defaultField) -> b.append(defaultField.getGenericType().getTypeName()).append(", ").append("default=").append(defaultField.get(null)))) {
            return;
        }
        if (ConfUtils.printKey(confClass, out, f, "PARAMETER", "CLASS", (b, classField) -> b.append(classField.get(null)))) {
            return;
        }
        String fieldName = f.getName();
        try {
            out.accept("constant: " + fieldName + " = " + f.get(null));
        }
        catch (IllegalAccessException e) {
            out.accept("WARNING: Failed to access " + f);
        }
    }

    public static boolean printKey(Class<?> confClass, Consumer<Object> out, Field f, String KEY, String DEFAULT, CheckedBiConsumer<StringBuilder, Field, IllegalAccessException> processDefault) {
        String fieldName = f.getName();
        if (fieldName.endsWith("_" + DEFAULT)) {
            return true;
        }
        if (!fieldName.endsWith("_" + KEY)) {
            return false;
        }
        StringBuilder b = new StringBuilder();
        try {
            Object keyName = f.get(null);
            b.append(KEY.toLowerCase()).append(": ").append(keyName);
        }
        catch (IllegalAccessException e) {
            out.accept("WARNING: Failed to access " + fieldName);
            b.append(fieldName + " is not public");
        }
        int len = fieldName.length() - KEY.length();
        String defaultFieldName = fieldName.substring(0, len) + DEFAULT;
        b.append(" (");
        try {
            Field defaultField = confClass.getDeclaredField(defaultFieldName);
            processDefault.accept(b, defaultField);
        }
        catch (NoSuchFieldException e) {
            out.accept("WARNING: " + DEFAULT + " not found for field " + f);
            b.append(DEFAULT).append(" not found");
        }
        catch (IllegalAccessException e) {
            out.accept("WARNING: Failed to access " + defaultFieldName);
            b.append(defaultFieldName).append(" is not public");
        }
        b.append(")");
        out.accept(b);
        return true;
    }
}

