/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.LongUnaryOperator;
import org.apache.ratis.util.CollectionUtils;

public final class TimeDuration
implements Comparable<TimeDuration> {
    private final long duration;
    private final TimeUnit unit;

    public static long parse(String timeString, TimeUnit targetUnit) {
        return TimeDuration.valueOf(timeString, targetUnit).toLong(targetUnit);
    }

    public static TimeDuration valueOf(String timeString, TimeUnit defaultUnit) {
        String lower = Objects.requireNonNull(timeString, "timeString = null").trim();
        for (Abbreviation a : Abbreviation.values()) {
            for (String s2 : a.getSymbols()) {
                if (!lower.endsWith(s2)) continue;
                String value = lower.substring(0, lower.length() - s2.length()).trim();
                try {
                    return TimeDuration.valueOf(Long.parseLong(value), a.unit());
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return TimeDuration.valueOf(Long.parseLong(lower), defaultUnit);
    }

    public static TimeDuration valueOf(long duration, TimeUnit unit) {
        return new TimeDuration(duration, unit);
    }

    private TimeDuration(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = Objects.requireNonNull(unit, "unit = null");
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long toLong(TimeUnit targetUnit) {
        return targetUnit.convert(this.duration, this.unit);
    }

    public int toIntExact(TimeUnit targetUnit) {
        return Math.toIntExact(this.toLong(targetUnit));
    }

    public TimeDuration to(TimeUnit targetUnit) {
        return this.unit == targetUnit ? this : TimeDuration.valueOf(this.toLong(targetUnit), targetUnit);
    }

    public TimeDuration minus(TimeDuration that) {
        Objects.requireNonNull(that, "that == null");
        TimeUnit minUnit = CollectionUtils.min(this.unit, that.unit);
        return TimeDuration.valueOf(this.toLong(minUnit) - that.toLong(minUnit), minUnit);
    }

    public long roundUpNanos(long nanos) {
        if (this.duration <= 0L) {
            throw new ArithmeticException("Rounding up to a non-positive " + this.getClass().getSimpleName() + " (=" + this + ")");
        }
        long divisor = this.toLong(TimeUnit.NANOSECONDS);
        if (nanos == 0L || divisor == 1L) {
            return nanos;
        }
        long remainder = nanos % divisor;
        if (remainder > 0L) {
            remainder -= divisor;
        }
        return nanos - remainder;
    }

    public TimeDuration apply(LongUnaryOperator operator) {
        return TimeDuration.valueOf(operator.applyAsLong(this.duration), this.unit);
    }

    public boolean isNegative() {
        return this.duration < 0L;
    }

    public boolean isNonPositive() {
        return this.duration <= 0L;
    }

    public void sleep() throws InterruptedException {
        this.unit.sleep(this.duration);
    }

    @Override
    public int compareTo(TimeDuration that) {
        if (this.unit.compareTo(that.unit) > 0) {
            return that.compareTo(this);
        }
        if (this.unit == that.unit) {
            return Long.compare(this.duration, that.duration);
        }
        long thisDurationInThatUnit = this.toLong(that.unit);
        if (thisDurationInThatUnit == that.duration) {
            long thatDurationInThisUnit = that.toLong(this.unit);
            return Long.compare(this.duration, thatDurationInThisUnit);
        }
        return Long.compare(thisDurationInThatUnit, that.duration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeDuration)) {
            return false;
        }
        TimeDuration that = (TimeDuration)obj;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Long.hashCode(this.toLong(TimeUnit.NANOSECONDS));
    }

    public String toString() {
        return this.duration + Abbreviation.valueOf(this.unit).getDefault();
    }

    public static enum Abbreviation {
        NANOSECONDS("ns", "nanos"),
        MICROSECONDS("us", "\u03bcs", "micros"),
        MILLISECONDS("ms", "msec", "millis"),
        SECONDS("s", "sec"),
        MINUTES("m", "min"),
        HOURS("h", "hr"),
        DAYS("d");

        private final TimeUnit unit = TimeUnit.valueOf(this.name());
        private final List<String> symbols;

        private Abbreviation(String ... symbols) {
            List<String> input = Arrays.asList(symbols);
            ArrayList<String> all = new ArrayList<String>(input.size() + 2);
            input.forEach(s2 -> all.add(s2.toLowerCase()));
            String s3 = this.unit.name().toLowerCase();
            all.add(s3);
            all.add(s3.substring(0, s3.length() - 1));
            this.symbols = Collections.unmodifiableList(all);
        }

        public TimeUnit unit() {
            return this.unit;
        }

        String getDefault() {
            return this.symbols.get(0);
        }

        public List<String> getSymbols() {
            return this.symbols;
        }

        public static Abbreviation valueOf(TimeUnit unit) {
            return Abbreviation.valueOf(unit.name());
        }
    }
}

