/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicFileOutputStream
extends FilterOutputStream {
    public static final String TMP_EXTENSION = ".tmp";
    public static final Logger LOG = LoggerFactory.getLogger(AtomicFileOutputStream.class);
    private final File origFile;
    private final File tmpFile;

    public AtomicFileOutputStream(File f) throws FileNotFoundException {
        super(new FileOutputStream(new File(f.getParentFile(), f.getName() + TMP_EXTENSION)));
        this.origFile = f.getAbsoluteFile();
        this.tmpFile = new File(f.getParentFile(), f.getName() + TMP_EXTENSION).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block11: {
            boolean triedToClose;
            block10: {
                block12: {
                    triedToClose = false;
                    boolean success = false;
                    try {
                        this.flush();
                        ((FileOutputStream)this.out).getChannel().force(true);
                        triedToClose = true;
                        super.close();
                        success = true;
                        if (!success) break block10;
                        boolean renamed = this.tmpFile.renameTo(this.origFile);
                        if (renamed) break block11;
                        if (!this.origFile.exists() || this.origFile.delete()) break block12;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            boolean renamed = this.tmpFile.renameTo(this.origFile);
                            if (!renamed) {
                                if (this.origFile.exists() && !this.origFile.delete()) {
                                    throw new IOException("Could not delete original file " + this.origFile);
                                }
                                FileUtils.move(this.tmpFile, this.origFile);
                            }
                        } else {
                            if (!triedToClose) {
                                IOUtils.cleanup(LOG, this.out);
                            }
                            if (!this.tmpFile.delete()) {
                                LOG.warn("Unable to delete tmp file " + this.tmpFile);
                            }
                        }
                        throw throwable;
                    }
                    throw new IOException("Could not delete original file " + this.origFile);
                }
                FileUtils.move(this.tmpFile, this.origFile);
                break block11;
            }
            if (!triedToClose) {
                IOUtils.cleanup(LOG, this.out);
            }
            if (!this.tmpFile.delete()) {
                LOG.warn("Unable to delete tmp file " + this.tmpFile);
            }
        }
    }

    public void abort() {
        try {
            super.close();
        }
        catch (IOException ioe) {
            LOG.warn("Unable to abort file " + this.tmpFile, ioe);
        }
        if (!this.tmpFile.delete()) {
            LOG.warn("Unable to delete tmp file during abort " + this.tmpFile);
        }
    }
}

