/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.opencensus.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.io.opencensus.stats.AutoValue_BucketBoundaries;

@Immutable
public abstract class BucketBoundaries {
    public static final BucketBoundaries create(List<Double> bucketBoundaries) {
        Preconditions.checkNotNull(bucketBoundaries, "bucketBoundaries list should not be null.");
        ArrayList<Double> bucketBoundariesCopy = new ArrayList<Double>(bucketBoundaries);
        if (bucketBoundariesCopy.size() > 1) {
            double lower = (Double)bucketBoundariesCopy.get(0);
            for (int i = 1; i < bucketBoundariesCopy.size(); ++i) {
                double next = (Double)bucketBoundariesCopy.get(i);
                Preconditions.checkArgument(lower < next, "Bucket boundaries not sorted.");
                lower = next;
            }
        }
        return new AutoValue_BucketBoundaries(Collections.unmodifiableList(bucketBoundariesCopy));
    }

    public abstract List<Double> getBoundaries();
}

