/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;

public class TransactionContextImpl
implements TransactionContext {
    private final RaftProtos.RaftPeerRole serverRole;
    private final StateMachine stateMachine;
    private RaftClientRequest clientRequest;
    private Exception exception;
    private RaftProtos.StateMachineLogEntryProto smLogEntryProto;
    private Object stateMachineContext;
    private boolean shouldCommit = true;
    private RaftProtos.LogEntryProto logEntry;

    private TransactionContextImpl(RaftProtos.RaftPeerRole serverRole, StateMachine stateMachine) {
        this.serverRole = serverRole;
        this.stateMachine = stateMachine;
    }

    public TransactionContextImpl(StateMachine stateMachine, RaftClientRequest clientRequest, RaftProtos.StateMachineLogEntryProto smLogEntryProto, Object stateMachineContext) {
        this(RaftProtos.RaftPeerRole.LEADER, stateMachine);
        this.clientRequest = clientRequest;
        this.smLogEntryProto = smLogEntryProto != null ? smLogEntryProto : ServerProtoUtils.toStateMachineLogEntryProto(clientRequest, null, null);
        this.stateMachineContext = stateMachineContext;
    }

    public TransactionContextImpl(RaftProtos.RaftPeerRole serverRole, StateMachine stateMachine, RaftProtos.LogEntryProto logEntry) {
        this(serverRole, stateMachine);
        this.logEntry = logEntry;
        this.smLogEntryProto = logEntry.getStateMachineLogEntry();
    }

    @Override
    public RaftProtos.RaftPeerRole getServerRole() {
        return this.serverRole;
    }

    @Override
    public RaftClientRequest getClientRequest() {
        return this.clientRequest;
    }

    @Override
    public RaftProtos.StateMachineLogEntryProto getStateMachineLogEntry() {
        return this.smLogEntryProto;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public TransactionContext setStateMachineContext(Object stateMachineContext) {
        this.stateMachineContext = stateMachineContext;
        return this;
    }

    @Override
    public Object getStateMachineContext() {
        return this.stateMachineContext;
    }

    @Override
    public RaftProtos.LogEntryProto initLogEntry(long term, long index) {
        Preconditions.assertTrue(this.serverRole == RaftProtos.RaftPeerRole.LEADER);
        Preconditions.assertNull((Object)this.logEntry, "logEntry");
        Objects.requireNonNull(this.smLogEntryProto, "smLogEntryProto == null");
        this.logEntry = ServerProtoUtils.toLogEntryProto(this.smLogEntryProto, term, index);
        return this.logEntry;
    }

    @Override
    public TransactionContext setStateMachineLogEntryProto(RaftProtos.StateMachineLogEntryProto smLogEntryProto) {
        this.smLogEntryProto = smLogEntryProto;
        return this;
    }

    @Override
    public RaftProtos.LogEntryProto getLogEntry() {
        return this.logEntry;
    }

    @Override
    public TransactionContext setException(Exception ioe) {
        this.exception = ioe;
        return this;
    }

    @Override
    public TransactionContext setShouldCommit(boolean shouldCommit) {
        this.shouldCommit = shouldCommit;
        return this;
    }

    @Override
    public boolean shouldCommit() {
        return this.shouldCommit;
    }

    @Override
    public TransactionContext preAppendTransaction() throws IOException {
        return this.stateMachine.preAppendTransaction(this);
    }

    @Override
    public TransactionContext cancelTransaction() throws IOException {
        return this.stateMachine.cancelTransaction(this);
    }
}

