/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.impl.FileListSnapshotInfo;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.util.MD5FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStateMachineStorage
implements StateMachineStorage {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleStateMachineStorage.class);
    static final String SNAPSHOT_FILE_PREFIX = "snapshot";
    static final String CORRUPT_SNAPSHOT_FILE_SUFFIX = ".corrupt";
    static final Pattern SNAPSHOT_REGEX = Pattern.compile("snapshot\\.(\\d+)_(\\d+)");
    private RaftStorage raftStorage;
    private File smDir = null;
    private volatile SingleFileSnapshotInfo currentSnapshot = null;

    @Override
    public void init(RaftStorage raftStorage) throws IOException {
        this.raftStorage = raftStorage;
        this.smDir = raftStorage.getStorageDir().getStateMachineDir();
        this.loadLatestSnapshot();
    }

    @Override
    public void format() throws IOException {
    }

    public static TermIndex getTermIndexFromSnapshotFile(File file) {
        String name = file.getName();
        Matcher m3 = SNAPSHOT_REGEX.matcher(name);
        if (!m3.matches()) {
            throw new IllegalArgumentException("File \"" + file + "\" does not match snapshot file name pattern \"" + SNAPSHOT_REGEX + "\"");
        }
        long term = Long.parseLong(m3.group(1));
        long index = Long.parseLong(m3.group(2));
        return TermIndex.newTermIndex(term, index);
    }

    protected static String getTmpSnapshotFileName(long term, long endIndex) {
        return SimpleStateMachineStorage.getSnapshotFileName(term, endIndex) + ".tmp";
    }

    protected static String getCorruptSnapshotFileName(long term, long endIndex) {
        return SimpleStateMachineStorage.getSnapshotFileName(term, endIndex) + CORRUPT_SNAPSHOT_FILE_SUFFIX;
    }

    public File getSnapshotFile(long term, long endIndex) {
        return new File(this.smDir, SimpleStateMachineStorage.getSnapshotFileName(term, endIndex));
    }

    protected File getTmpSnapshotFile(long term, long endIndex) {
        return new File(this.smDir, SimpleStateMachineStorage.getTmpSnapshotFileName(term, endIndex));
    }

    protected File getCorruptSnapshotFile(long term, long endIndex) {
        return new File(this.smDir, SimpleStateMachineStorage.getCorruptSnapshotFileName(term, endIndex));
    }

    public SingleFileSnapshotInfo findLatestSnapshot() throws IOException {
        FileListSnapshotInfo latest = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.smDir.toPath());){
            for (Path path : stream) {
                Matcher matcher = SNAPSHOT_REGEX.matcher(path.getFileName().toString());
                if (!matcher.matches()) continue;
                long endIndex = Long.parseLong(matcher.group(2));
                if (latest != null && endIndex <= latest.getIndex()) continue;
                long term = Long.parseLong(matcher.group(1));
                MD5Hash fileDigest = MD5FileUtil.readStoredMd5ForFile(path.toFile());
                FileInfo fileInfo = new FileInfo(path, fileDigest);
                latest = new SingleFileSnapshotInfo(fileInfo, term, endIndex);
            }
        }
        return latest;
    }

    public void loadLatestSnapshot() throws IOException {
        this.currentSnapshot = this.findLatestSnapshot();
    }

    public static String getSnapshotFileName(long term, long endIndex) {
        return "snapshot." + term + "_" + endIndex;
    }

    @Override
    public SingleFileSnapshotInfo getLatestSnapshot() {
        return this.currentSnapshot;
    }
}

