/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.function.CheckedSupplier;

interface RaftLogSequentialOps {
    public long append(long var1, TransactionContext var3) throws StateMachineException;

    public long append(long var1, RaftConfiguration var3);

    public long appendMetadata(long var1, long var3);

    public CompletableFuture<Long> appendEntry(RaftProtos.LogEntryProto var1);

    public List<CompletableFuture<Long>> append(RaftProtos.LogEntryProto ... var1);

    public CompletableFuture<Long> truncate(long var1);

    public static class Runner {
        private final Object name;
        private final AtomicReference<Thread> runner = new AtomicReference();

        Runner(Supplier<String> name) {
            this.name = StringUtils.stringSupplierAsObject(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <OUTPUT, THROWABLE extends Throwable> OUTPUT runSequentially(CheckedSupplier<OUTPUT, THROWABLE> operation) throws THROWABLE {
            Thread current = Thread.currentThread();
            Thread previous = this.runner.getAndUpdate(prev -> prev != null ? prev : current);
            if (previous == null) {
                OUTPUT OUTPUT;
                try {
                    OUTPUT = operation.get();
                    Thread got = this.runner.getAndUpdate(prev -> prev != current ? prev : null);
                    Preconditions.assertTrue(got == current, () -> this.name + ": Unexpected runner " + got + " != " + current);
                }
                catch (Throwable throwable) {
                    Thread got = this.runner.getAndUpdate(prev -> prev != current ? prev : null);
                    Preconditions.assertTrue(got == current, () -> this.name + ": Unexpected runner " + got + " != " + current);
                    throw throwable;
                }
                return OUTPUT;
            }
            if (previous == current) {
                return operation.get();
            }
            throw new IllegalStateException(this.name + ": Already running a method by " + previous + ", current=" + current);
        }
    }
}

