/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.ratis.util.AtomicFileOutputStream;
import org.apache.ratis.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaFile {
    private static final Logger LOG = LoggerFactory.getLogger(MetaFile.class);
    private static final String TERM_KEY = "term";
    private static final String VOTEDFOR_KEY = "votedFor";
    static final long DEFAULT_TERM = 0L;
    static final String EMPTY_VOTEFOR = "";
    private final File file;
    private boolean loaded = false;
    private long term;
    private String votedFor;

    MetaFile(File file) {
        this.file = file;
        this.term = 0L;
        this.votedFor = EMPTY_VOTEFOR;
    }

    boolean exists() {
        return this.file.exists();
    }

    long getTerm() throws IOException {
        if (!this.loaded) {
            this.readFile();
            this.loaded = true;
        }
        return this.term;
    }

    String getVotedFor() throws IOException {
        if (!this.loaded) {
            this.readFile();
            this.loaded = true;
        }
        return this.votedFor;
    }

    void set(long newTerm, String newVotedFor) throws IOException {
        String string = newVotedFor = newVotedFor == null ? EMPTY_VOTEFOR : newVotedFor;
        if (!this.loaded || newTerm != this.term || !newVotedFor.equals(this.votedFor)) {
            this.writeFile(newTerm, newVotedFor);
        }
        this.term = newTerm;
        this.votedFor = newVotedFor;
        this.loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(long term, String votedFor) throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.file);
        Properties properties = new Properties();
        properties.setProperty(TERM_KEY, Long.toString(term));
        properties.setProperty(VOTEDFOR_KEY, votedFor);
        try {
            properties.store(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8)), EMPTY_VOTEFOR);
            fos.close();
            fos = null;
        }
        finally {
            if (fos != null) {
                fos.abort();
            }
        }
    }

    void readFile() throws IOException {
        this.term = 0L;
        this.votedFor = EMPTY_VOTEFOR;
        if (this.file.exists()) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
            try {
                Properties properties = new Properties();
                properties.load(br);
                if (!properties.containsKey(TERM_KEY) || !properties.containsKey(VOTEDFOR_KEY)) {
                    throw new IOException("Corrupted term/votedFor properties: " + properties);
                }
                this.term = Long.parseLong((String)properties.get(TERM_KEY));
                this.votedFor = (String)properties.get(VOTEDFOR_KEY);
            }
            catch (IOException e) {
                try {
                    LOG.warn("Cannot load term/votedFor properties from {}", (Object)this.file, (Object)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.cleanup(LOG, br);
                    throw throwable;
                }
            }
            IOUtils.cleanup(LOG, br);
        }
    }
}

