/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ratis.server.storage.BufferedChannelBase;

public class BufferedWriteChannel
extends BufferedChannelBase {
    private final int writeCapacity;
    private AtomicLong writeBufferStartPosition = new AtomicLong(0L);
    private final ByteBuffer writeBuffer;
    private volatile long position;

    public BufferedWriteChannel(FileChannel fc, int writeCapacity) throws IOException {
        super(fc);
        this.writeCapacity = writeCapacity;
        this.position = fc.position();
        this.writeBufferStartPosition.set(this.position);
        this.writeBuffer = ByteBuffer.allocateDirect(writeCapacity);
    }

    public void write(ByteBuffer src) throws IOException {
        int copied = 0;
        while (src.remaining() > 0) {
            int truncated = 0;
            if (this.writeBuffer.remaining() < src.remaining()) {
                truncated = src.remaining() - this.writeBuffer.remaining();
                src.limit(src.limit() - truncated);
            }
            copied += src.remaining();
            this.writeBuffer.put(src);
            src.limit(src.limit() + truncated);
            if (this.writeBuffer.remaining() != 0) continue;
            this.flushInternal();
        }
        this.position += (long)copied;
    }

    public void write(int b) throws IOException {
        this.writeBuffer.put((byte)b);
        if (this.writeBuffer.remaining() == 0) {
            this.flushInternal();
        }
        ++this.position;
    }

    public void write(byte[] b) throws IOException {
        int toPut;
        for (int offset = 0; offset < b.length; offset += toPut) {
            toPut = Math.min(b.length - offset, this.writeBuffer.remaining());
            this.writeBuffer.put(b, offset, toPut);
            if (this.writeBuffer.remaining() != 0) continue;
            this.flushInternal();
        }
        this.position += (long)b.length;
    }

    public long position() {
        return this.position;
    }

    public long getFileChannelPosition() {
        return this.writeBufferStartPosition.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean shouldForceWrite) throws IOException {
        BufferedWriteChannel bufferedWriteChannel = this;
        synchronized (bufferedWriteChannel) {
            this.flushInternal();
        }
        if (shouldForceWrite) {
            this.forceWrite(false);
        }
    }

    private void flushInternal() throws IOException {
        this.writeBuffer.flip();
        do {
            this.fileChannel.write(this.writeBuffer);
        } while (this.writeBuffer.hasRemaining());
        this.writeBuffer.clear();
        this.writeBufferStartPosition.set(this.fileChannel.position());
    }

    public long forceWrite(boolean forceMetadata) throws IOException {
        long positionForceWrite = this.writeBufferStartPosition.get();
        this.fileChannel.force(forceMetadata);
        return positionForceWrite;
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
        this.writeBuffer.clear();
    }
}

