/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.util.Preconditions;

public class RaftConfiguration {
    private final PeerConfiguration oldConf;
    private final PeerConfiguration conf;
    private final long logEntryIndex;

    public static Builder newBuilder() {
        return new Builder();
    }

    private RaftConfiguration(PeerConfiguration conf, PeerConfiguration oldConf, long logEntryIndex) {
        this.conf = Objects.requireNonNull(conf);
        this.oldConf = oldConf;
        this.logEntryIndex = logEntryIndex;
    }

    boolean isTransitional() {
        return this.oldConf != null;
    }

    boolean isStable() {
        return this.oldConf == null;
    }

    boolean containsInConf(RaftPeerId peerId) {
        return this.conf.contains(peerId);
    }

    boolean containsInOldConf(RaftPeerId peerId) {
        return this.oldConf != null && this.oldConf.contains(peerId);
    }

    boolean contains(RaftPeerId peerId) {
        return this.containsInConf(peerId) && (this.oldConf == null || this.containsInOldConf(peerId));
    }

    public RaftPeer getPeer(RaftPeerId id) {
        if (id == null) {
            return null;
        }
        RaftPeer peer = this.conf.getPeer(id);
        if (peer != null) {
            return peer;
        }
        if (this.oldConf != null) {
            return this.oldConf.getPeer(id);
        }
        return null;
    }

    public Collection<RaftPeer> getPeers() {
        ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>(this.conf.getPeers());
        if (this.oldConf != null) {
            this.oldConf.getPeers().stream().filter(p -> !peers.contains(p)).forEach(peers::add);
        }
        return peers;
    }

    public Collection<RaftPeer> getOtherPeers(RaftPeerId selfId) {
        List<RaftPeer> others = this.conf.getOtherPeers(selfId);
        if (this.oldConf != null) {
            this.oldConf.getOtherPeers(selfId).stream().filter(p -> !others.contains(p)).forEach(others::add);
        }
        return others;
    }

    boolean hasMajority(Collection<RaftPeerId> others, RaftPeerId selfId) {
        Preconditions.assertTrue(!others.contains(selfId));
        return this.conf.hasMajority(others, selfId) && (this.oldConf == null || this.oldConf.hasMajority(others, selfId));
    }

    public String toString() {
        return this.logEntryIndex + ": " + this.conf + ", old=" + this.oldConf;
    }

    boolean hasNoChange(RaftPeer[] newMembers) {
        if (!this.isStable() || this.conf.size() != newMembers.length) {
            return false;
        }
        for (RaftPeer peer : newMembers) {
            if (this.conf.contains(peer.getId())) continue;
            return false;
        }
        return true;
    }

    long getLogEntryIndex() {
        return this.logEntryIndex;
    }

    static Collection<RaftPeer> computeNewPeers(RaftPeer[] newMembers, RaftConfiguration old) {
        ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>();
        for (RaftPeer p : newMembers) {
            if (old.containsInConf(p.getId())) continue;
            peers.add(p);
        }
        return peers;
    }

    RaftPeer getRandomPeer(RaftPeerId exclusiveId) {
        List<RaftPeer> peers = this.conf.getOtherPeers(exclusiveId);
        if (peers.isEmpty()) {
            return null;
        }
        int index = ThreadLocalRandom.current().nextInt(peers.size());
        return peers.get(index);
    }

    Collection<RaftPeer> getPeersInOldConf() {
        return this.oldConf != null ? this.oldConf.getPeers() : Collections.emptyList();
    }

    Collection<RaftPeer> getPeersInConf() {
        return this.conf.getPeers();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RaftConfiguration that = (RaftConfiguration)obj;
        return this.logEntryIndex == that.logEntryIndex && Objects.equals(this.conf, that.conf) && Objects.equals(this.oldConf, that.oldConf);
    }

    public int hashCode() {
        return Long.hashCode(this.logEntryIndex);
    }

    public static class Builder {
        private PeerConfiguration oldConf;
        private PeerConfiguration conf;
        private long logEntryIndex = -1L;
        private boolean forceStable = false;
        private boolean forceTransitional = false;

        private Builder() {
        }

        public Builder setConf(PeerConfiguration conf) {
            Objects.requireNonNull(conf);
            Preconditions.assertTrue(this.conf == null, "conf is already set.");
            this.conf = conf;
            return this;
        }

        public Builder setConf(Iterable<RaftPeer> peers) {
            return this.setConf(new PeerConfiguration(peers));
        }

        public Builder setConf(RaftPeer[] peers) {
            return this.setConf(Arrays.asList(peers));
        }

        Builder setConf(RaftConfiguration transitionalConf) {
            Objects.requireNonNull(transitionalConf);
            Preconditions.assertTrue(transitionalConf.isTransitional());
            Preconditions.assertTrue(!this.forceTransitional);
            this.forceStable = true;
            return this.setConf(transitionalConf.conf);
        }

        public Builder setOldConf(PeerConfiguration oldConf) {
            Objects.requireNonNull(oldConf);
            Preconditions.assertTrue(this.oldConf == null, "oldConf is already set.");
            this.oldConf = oldConf;
            return this;
        }

        public Builder setOldConf(Iterable<RaftPeer> oldPeers) {
            return this.setOldConf(new PeerConfiguration(oldPeers));
        }

        public Builder setOldConf(RaftPeer[] oldPeers) {
            return this.setOldConf(Arrays.asList(oldPeers));
        }

        Builder setOldConf(RaftConfiguration stableConf) {
            Objects.requireNonNull(stableConf);
            Preconditions.assertTrue(stableConf.isStable());
            Preconditions.assertTrue(!this.forceStable);
            this.forceTransitional = true;
            return this.setOldConf(stableConf.conf);
        }

        public Builder setLogEntryIndex(long logEntryIndex) {
            Preconditions.assertTrue(logEntryIndex != -1L);
            Preconditions.assertTrue(this.logEntryIndex == -1L, "logEntryIndex is already set.");
            this.logEntryIndex = logEntryIndex;
            return this;
        }

        public RaftConfiguration build() {
            if (this.forceTransitional) {
                Preconditions.assertTrue(this.oldConf != null);
            }
            if (this.forceStable) {
                Preconditions.assertTrue(this.oldConf == null);
            }
            return new RaftConfiguration(this.conf, this.oldConf, this.logEntryIndex);
        }
    }
}

