/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingRequests {
    public static final Logger LOG = LoggerFactory.getLogger(PendingRequests.class);
    private PendingRequest pendingSetConf;
    private final String name;
    private final RequestMap pendingRequests;

    PendingRequests(RaftPeerId id) {
        this.name = id + "-" + this.getClass().getSimpleName();
        this.pendingRequests = new RequestMap(id);
    }

    PendingRequest add(RaftClientRequest request, TransactionContext entry) {
        Preconditions.assertTrue(request.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE));
        long index = entry.getLogEntry().getIndex();
        LOG.debug("{}: addPendingRequest at index={}, request={}", this.name, index, request);
        PendingRequest pending = new PendingRequest(index, request, entry);
        this.pendingRequests.put(index, pending);
        return pending;
    }

    PendingRequest addConfRequest(SetConfigurationRequest request) {
        Preconditions.assertTrue(this.pendingSetConf == null);
        this.pendingSetConf = new PendingRequest(request);
        return this.pendingSetConf;
    }

    void replySetConfiguration(Supplier<Collection<RaftProtos.CommitInfoProto>> getCommitInfos) {
        if (this.pendingSetConf != null) {
            RaftClientRequest request = this.pendingSetConf.getRequest();
            LOG.debug("{}: sends success for {}", (Object)this.name, (Object)request);
            this.pendingSetConf.setReply(new RaftClientReply(request, getCommitInfos.get()));
            this.pendingSetConf = null;
        }
    }

    void failSetConfiguration(RaftException e) {
        Preconditions.assertTrue(this.pendingSetConf != null);
        this.pendingSetConf.setException(e);
        this.pendingSetConf = null;
    }

    TransactionContext getTransactionContext(long index) {
        PendingRequest pendingRequest = this.pendingRequests.get(index);
        return pendingRequest != null ? pendingRequest.getEntry() : null;
    }

    void replyPendingRequest(long index, RaftClientReply reply) {
        PendingRequest pending = this.pendingRequests.remove(index);
        if (pending != null) {
            Preconditions.assertTrue(pending.getIndex() == index);
            pending.setReply(reply);
        }
    }

    Collection<TransactionContext> sendNotLeaderResponses(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        LOG.info("{}: sendNotLeaderResponses", (Object)this.name);
        Collection<TransactionContext> transactions = this.pendingRequests.setNotLeaderException(nle, commitInfos);
        if (this.pendingSetConf != null) {
            this.pendingSetConf.setNotLeaderException(nle, commitInfos);
        }
        return transactions;
    }

    private static class RequestMap {
        private final Object name;
        private final ConcurrentMap<Long, PendingRequest> map = new ConcurrentHashMap<Long, PendingRequest>();

        RequestMap(Object name) {
            this.name = name;
        }

        void put(long index, PendingRequest p) {
            LOG.debug("{}: PendingRequests.put {} -> {}", this.name, index, p);
            PendingRequest previous = this.map.put(index, p);
            Preconditions.assertTrue(previous == null);
        }

        PendingRequest get(long index) {
            PendingRequest r = (PendingRequest)this.map.get(index);
            LOG.debug("{}: PendingRequests.get {} returns {}", this.name, index, r);
            return r;
        }

        PendingRequest remove(long index) {
            PendingRequest r = (PendingRequest)this.map.remove(index);
            LOG.debug("{}: PendingRequests.remove {} returns {}", this.name, index, r);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<TransactionContext> setNotLeaderException(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
            LOG.debug("{}: PendingRequests.setNotLeaderException", this.name);
            try {
                Collection collection = this.map.values().stream().map(p -> p.setNotLeaderException(nle, commitInfos)).collect(Collectors.toList());
                return collection;
            }
            finally {
                this.map.clear();
            }
        }
    }
}

