/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;

public interface RetryPolicies {
    public static RetryPolicy retryForeverNoSleep() {
        return Constants.RETRY_FOREVER_NO_SLEEP;
    }

    public static RetryPolicy noRetry() {
        return Constants.NO_RETRY;
    }

    public static RetryPolicy retryForeverWithSleep(TimeDuration sleepTime) {
        return new RetryForeverWithSleep(sleepTime);
    }

    public static RetryLimited retryUpToMaximumCountWithFixedSleep(int maxAttempts, TimeDuration sleepTime) {
        return new RetryLimited(maxAttempts, sleepTime);
    }

    public static class RetryLimited
    implements RetryPolicy {
        private final int maxAttempts;
        private final TimeDuration sleepTime;
        private String myString;

        RetryLimited(int maxAttempts, TimeDuration sleepTime) {
            if (maxAttempts < 0) {
                throw new IllegalArgumentException("maxAttempts = " + maxAttempts + " < 0");
            }
            if (sleepTime.isNegative()) {
                throw new IllegalArgumentException("sleepTime = " + sleepTime.getDuration() + " < 0");
            }
            this.maxAttempts = maxAttempts;
            this.sleepTime = sleepTime;
        }

        @Override
        public TimeDuration getSleepTime() {
            return this.sleepTime;
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        @Override
        public boolean shouldRetry(int attemptCount) {
            return attemptCount <= this.maxAttempts;
        }

        public String toString() {
            if (this.myString == null) {
                this.myString = this.getClass().getSimpleName() + "(maxAttempts=" + this.maxAttempts + ", sleepTime=" + this.sleepTime + ")";
            }
            return this.myString;
        }
    }

    public static class RetryForeverWithSleep
    implements RetryPolicy {
        private final TimeDuration sleepTime;
        private String myString;

        RetryForeverWithSleep(TimeDuration sleepTime) {
            if (sleepTime.isNegative()) {
                throw new IllegalArgumentException("sleepTime = " + sleepTime.getDuration() + " < 0");
            }
            this.sleepTime = sleepTime;
        }

        @Override
        public TimeDuration getSleepTime() {
            return this.sleepTime;
        }

        @Override
        public boolean shouldRetry(int attemptCount) {
            return true;
        }

        public String toString() {
            if (this.myString == null) {
                this.myString = this.getClass().getSimpleName() + "(sleepTime = " + this.sleepTime + ")";
            }
            return this.myString;
        }
    }

    public static class NoRetry
    implements RetryPolicy {
        private NoRetry() {
        }

        @Override
        public boolean shouldRetry(int attemptCount) {
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class RetryForeverNoSleep
    implements RetryPolicy {
        private RetryForeverNoSleep() {
        }

        @Override
        public boolean shouldRetry(int attemptCount) {
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class Constants {
        private static final RetryForeverNoSleep RETRY_FOREVER_NO_SLEEP = new RetryForeverNoSleep();
        private static final NoRetry NO_RETRY = new NoRetry();
    }
}

