/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;

public class RaftPeerId {
    private static final Map<ByteString, RaftPeerId> byteStringMap = new ConcurrentHashMap<ByteString, RaftPeerId>();
    private static final Map<String, RaftPeerId> stringMap = new ConcurrentHashMap<String, RaftPeerId>();
    private final String idString;
    private final ByteString id;

    public static RaftPeerId valueOf(ByteString id) {
        return byteStringMap.computeIfAbsent(id, RaftPeerId::new);
    }

    public static RaftPeerId valueOf(String id) {
        return stringMap.computeIfAbsent(id, RaftPeerId::new);
    }

    public static RaftPeerId getRaftPeerId(String id) {
        return id == null || id.isEmpty() ? null : RaftPeerId.valueOf(id);
    }

    private RaftPeerId(String id) {
        this.idString = Objects.requireNonNull(id, "id == null");
        Preconditions.assertTrue(!id.isEmpty(), "id is an empty string.");
        this.id = ByteString.copyFrom(this.idString, StandardCharsets.UTF_8);
    }

    private RaftPeerId(ByteString id) {
        this.id = Objects.requireNonNull(id, "id == null");
        Preconditions.assertTrue(id.size() > 0, "id is empty.");
        this.idString = id.toString(StandardCharsets.UTF_8);
    }

    public ByteString toByteString() {
        return this.id;
    }

    public String toString() {
        return this.idString;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof RaftPeerId && this.idString.equals(((RaftPeerId)other).idString);
    }

    public int hashCode() {
        return this.idString.hashCode();
    }
}

