/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.function.Supplier;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.StringUtils;

public interface Message {
    public static final Message EMPTY = Message.valueOf(ByteString.EMPTY);

    public static Message valueOf(final ByteString bytes, final Supplier<String> stringSupplier) {
        return new Message(){
            private final MemoizedSupplier<String> memoized;
            {
                this.memoized = MemoizedSupplier.valueOf(stringSupplier);
            }

            @Override
            public ByteString getContent() {
                return bytes;
            }

            public String toString() {
                return this.memoized.get();
            }
        };
    }

    public static Message valueOf(ByteString bytes) {
        return Message.valueOf(bytes, () -> "Message:" + StringUtils.bytes2HexShortString(bytes));
    }

    public static Message valueOf(String string) {
        return Message.valueOf(ByteString.copyFromUtf8(string), () -> "Message:" + string);
    }

    public ByteString getContent();
}

