/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.Supplier;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.client.GrpcClientProtocolService;
import org.apache.ratis.grpc.server.GrpcAdminProtocolService;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcServerProtocolService;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.RaftServerRpcWithProxy;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.ClientAuth;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcService
extends RaftServerRpcWithProxy<GrpcServerProtocolClient, PeerProxyMap<GrpcServerProtocolClient>> {
    static final Logger LOG = LoggerFactory.getLogger(GrpcService.class);
    public static final String GRPC_SEND_SERVER_REQUEST = GrpcService.class.getSimpleName() + ".sendRequest";
    private final Server server;
    private final Supplier<InetSocketAddress> addressSupplier;
    private final GrpcClientProtocolService clientProtocolService;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GrpcService(RaftServer server, GrpcTlsConfig tlsConfig) {
        this(server, server::getId, GrpcConfigKeys.Server.port(server.getProperties()), GrpcConfigKeys.messageSizeMax(server.getProperties(), LOG::info), RaftServerConfigKeys.Log.Appender.bufferByteLimit(server.getProperties()), GrpcConfigKeys.flowControlWindow(server.getProperties(), LOG::info), RaftServerConfigKeys.Rpc.requestTimeout(server.getProperties()), tlsConfig);
    }

    private GrpcService(RaftServer raftServer, Supplier<RaftPeerId> idSupplier, int port, SizeInBytes grpcMessageSizeMax, SizeInBytes appenderBufferSize, SizeInBytes flowControlWindow, TimeDuration requestTimeoutDuration, GrpcTlsConfig tlsConfig) {
        super(idSupplier, (RaftPeerId id) -> new PeerProxyMap<GrpcServerProtocolClient>(id.toString(), p -> new GrpcServerProtocolClient((RaftPeer)p, flowControlWindow.getSizeInt(), requestTimeoutDuration, tlsConfig)));
        if (appenderBufferSize.getSize() > grpcMessageSizeMax.getSize()) {
            throw new IllegalArgumentException("Illegal configuration: raft.server.log.appender.buffer.byte-limit = " + appenderBufferSize + " > " + "raft.grpc.message.size.max" + " = " + grpcMessageSizeMax);
        }
        this.clientProtocolService = new GrpcClientProtocolService(idSupplier, raftServer);
        NettyServerBuilder nettyServerBuilder = (NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort(port).maxInboundMessageSize(grpcMessageSizeMax.getSizeInt()).flowControlWindow(flowControlWindow.getSizeInt()).addService(new GrpcServerProtocolService(idSupplier, raftServer))).addService(this.clientProtocolService)).addService(new GrpcAdminProtocolService(raftServer));
        if (tlsConfig != null) {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer(tlsConfig.getCertChain(), tlsConfig.getPrivateKey());
            if (tlsConfig.getMtlsEnabled()) {
                sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
                sslContextBuilder.trustManager(tlsConfig.getCertChain());
            }
            sslContextBuilder = GrpcSslContexts.configure(sslContextBuilder, SslProvider.OPENSSL);
            try {
                nettyServerBuilder.sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to build SslContext, tlsConfig=" + tlsConfig, ex);
            }
        }
        this.server = nettyServerBuilder.build();
        this.addressSupplier = JavaUtils.memoize(() -> new InetSocketAddress(port != 0 ? port : this.server.getPort()));
    }

    @Override
    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    @Override
    public void startImpl() {
        try {
            this.server.start();
        }
        catch (IOException e) {
            ExitUtils.terminate(1, "Failed to start Grpc server", e, LOG);
        }
        LOG.info("{}: {} started, listening on {}", this.getId(), this.getClass().getSimpleName(), this.getInetSocketAddress());
    }

    @Override
    public void closeImpl() throws IOException {
        String name = this.getId() + ": shutdown server with port " + this.server.getPort();
        LOG.info("{} now", (Object)name);
        Server s2 = this.server.shutdownNow();
        super.closeImpl();
        try {
            s2.awaitTermination();
        }
        catch (InterruptedException e) {
            throw IOUtils.toInterruptedIOException(name + " failed", e);
        }
        LOG.info("{} successfully", (Object)name);
    }

    @Override
    public void notifyNotLeader() {
        this.clientProtocolService.closeAllOrderedRequestStreamObservers();
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.addressSupplier.get();
    }

    @Override
    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    @Override
    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) {
        throw new UnsupportedOperationException("Blocking " + JavaUtils.getCurrentStackTraceElement().getMethodName() + " call is not supported");
    }

    @Override
    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(GRPC_SEND_SERVER_REQUEST, this.getId(), null, request);
        RaftPeerId target = RaftPeerId.valueOf(request.getServerRequest().getReplyId());
        return ((GrpcServerProtocolClient)((PeerProxyMap)this.getProxies()).getProxy(target)).requestVote(request);
    }

    public static class Builder
    extends RaftServerRpc.Builder<Builder, GrpcService> {
        private GrpcTlsConfig tlsConfig;

        private Builder() {
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public GrpcService build() {
            return new GrpcService(this.getServer(), this.getTlsConfig());
        }

        public Builder setTlsConfig(GrpcTlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public GrpcTlsConfig getTlsConfig() {
            return this.tlsConfig;
        }
    }
}

