/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcService;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcLogAppender
extends LogAppender {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcLogAppender.class);
    private final GrpcService rpcService;
    private final Map<Long, RaftProtos.AppendEntriesRequestProto> pendingRequests;
    private final int maxPendingRequestsNum;
    private long callId = 0L;
    private volatile boolean firstResponseReceived = false;
    private final boolean installSnapshotEnabled;
    private final TimeDuration requestTimeoutDuration;
    private final TimeoutScheduler scheduler = TimeoutScheduler.newInstance(1);
    private volatile StreamObserver<RaftProtos.AppendEntriesRequestProto> appendLogRequestObserver;

    public GrpcLogAppender(RaftServerImpl server, LeaderState leaderState, FollowerInfo f) {
        super(server, leaderState, f);
        this.rpcService = (GrpcService)server.getServerRpc();
        this.maxPendingRequestsNum = GrpcConfigKeys.Server.leaderOutstandingAppendsMax(server.getProxy().getProperties());
        this.requestTimeoutDuration = RaftServerConfigKeys.Rpc.requestTimeout(server.getProxy().getProperties());
        this.pendingRequests = new ConcurrentHashMap<Long, RaftProtos.AppendEntriesRequestProto>();
        this.installSnapshotEnabled = GrpcConfigKeys.LogAppender.installSnapshotEnabled(server.getProxy().getProperties());
    }

    private GrpcServerProtocolClient getClient() throws IOException {
        return (GrpcServerProtocolClient)((PeerProxyMap)this.rpcService.getProxies()).getProxy(this.follower.getPeer().getId());
    }

    private synchronized void resetClient(RaftProtos.AppendEntriesRequestProto request) {
        ((PeerProxyMap)this.rpcService.getProxies()).resetProxy(this.follower.getPeer().getId());
        this.appendLogRequestObserver = null;
        this.firstResponseReceived = false;
        long nextIndex = request != null && request.hasPreviousLog() ? request.getPreviousLog().getIndex() + 1L : this.raftLog.getStartIndex();
        this.clearPendingRequests(nextIndex);
    }

    @Override
    protected void runAppenderImpl() throws IOException {
        while (this.isAppenderRunning()) {
            boolean shouldAppendLog = true;
            if (this.shouldSendRequest()) {
                SnapshotInfo snapshot;
                if (this.installSnapshotEnabled && (snapshot = this.shouldInstallSnapshot()) != null) {
                    this.installSnapshot(snapshot);
                    shouldAppendLog = false;
                }
                if (shouldAppendLog && !this.shouldWait()) {
                    this.appendLog();
                }
            }
            this.checkSlowness();
            this.mayWait();
        }
        Optional.ofNullable(this.appendLogRequestObserver).ifPresent(StreamObserver::onCompleted);
    }

    private long getWaitTimeMs() {
        if (!this.shouldSendRequest()) {
            return this.getHeartbeatRemainingTime();
        }
        if (this.shouldWait()) {
            return this.halfMinTimeoutMs;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayWait() {
        long waitTimeMs = this.getWaitTimeMs();
        if (waitTimeMs <= 0L) {
            return;
        }
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            try {
                LOG.trace("{}: wait {}ms", (Object)this, (Object)waitTimeMs);
                this.wait(waitTimeMs);
            }
            catch (InterruptedException ie) {
                LOG.warn(this + ": Wait interrupted by " + ie);
            }
        }
    }

    @Override
    protected boolean shouldSendRequest() {
        return this.appendLogRequestObserver == null || super.shouldSendRequest();
    }

    private boolean shouldWait() {
        int size = this.pendingRequests.size();
        if (size == 0) {
            return false;
        }
        return !this.firstResponseReceived || size >= this.maxPendingRequestsNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLog() throws IOException {
        StreamObserver<RaftProtos.AppendEntriesRequestProto> s2;
        RaftProtos.AppendEntriesRequestProto pending;
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            pending = this.createRequest(this.callId++);
            if (pending == null) {
                return;
            }
            this.pendingRequests.put(pending.getServerRequest().getCallId(), pending);
            this.updateNextIndex(pending);
            if (this.appendLogRequestObserver == null) {
                this.appendLogRequestObserver = this.getClient().appendEntries(new AppendLogResponseHandler());
            }
            s2 = this.appendLogRequestObserver;
        }
        if (this.isAppenderRunning()) {
            this.sendRequest(pending, s2);
        }
    }

    private void sendRequest(RaftProtos.AppendEntriesRequestProto request, StreamObserver<RaftProtos.AppendEntriesRequestProto> s2) {
        CodeInjectionForTesting.execute(GrpcService.GRPC_SEND_SERVER_REQUEST, this.server.getId(), null, request);
        s2.onNext(request);
        this.scheduler.onTimeout(this.requestTimeoutDuration, () -> this.timeoutAppendRequest(request), LOG, () -> "Timeout check failed for append entry request: " + request);
        this.follower.updateLastRpcSendTime();
    }

    private void timeoutAppendRequest(RaftProtos.AppendEntriesRequestProto request) {
        RaftProtos.AppendEntriesRequestProto pendingRequest = this.pendingRequests.remove(request.getServerRequest().getCallId());
        if (pendingRequest != null) {
            LOG.warn("{}: appendEntries Timeout, request={}", (Object)this, (Object)ServerProtoUtils.toString(pendingRequest));
        }
    }

    private void updateNextIndex(RaftProtos.AppendEntriesRequestProto request) {
        int count = request.getEntriesCount();
        if (count > 0) {
            this.follower.updateNextIndex(request.getEntries(count - 1).getIndex() + 1L);
        }
    }

    private void clearPendingRequests(long newNextIndex) {
        this.pendingRequests.clear();
        this.follower.decreaseNextIndex(newNextIndex);
    }

    protected synchronized void onSuccess(RaftProtos.AppendEntriesReplyProto reply) {
        boolean updateMatchIndex;
        RaftProtos.AppendEntriesRequestProto request = this.pendingRequests.remove(reply.getServerReply().getCallId());
        if (request == null) {
            LOG.warn("{}: Request not found, ignoring reply: {}", (Object)this, (Object)ServerProtoUtils.toString(reply));
            return;
        }
        this.updateCommitIndex(reply.getFollowerCommit());
        long replyNextIndex = reply.getNextIndex();
        long lastIndex = replyNextIndex - 1L;
        if (request.getEntriesCount() == 0) {
            Preconditions.assertTrue(!request.hasPreviousLog() || lastIndex == request.getPreviousLog().getIndex(), "reply's next index is %s, request's previous is %s", replyNextIndex, request.getPreviousLog());
            updateMatchIndex = request.hasPreviousLog() && this.follower.getMatchIndex() < lastIndex;
        } else {
            long lastEntryIndex = request.getEntries(request.getEntriesCount() - 1).getIndex();
            Preconditions.assertTrue(lastIndex == lastEntryIndex, "reply's next index is %s, request's last entry index is %s", replyNextIndex, lastEntryIndex);
            updateMatchIndex = true;
        }
        if (updateMatchIndex) {
            this.follower.updateMatchIndex(lastIndex);
            this.submitEventOnSuccessAppend();
        }
    }

    private void onNotLeader(RaftProtos.AppendEntriesReplyProto reply) {
        this.checkResponseTerm(reply.getTerm());
    }

    private synchronized void onInconsistency(RaftProtos.AppendEntriesReplyProto reply) {
        RaftProtos.AppendEntriesRequestProto request = this.pendingRequests.remove(reply.getServerReply().getCallId());
        if (request == null) {
            LOG.warn("{}: Ignoring {}", (Object)this.server.getId(), (Object)reply);
            return;
        }
        Preconditions.assertTrue(request.hasPreviousLog());
        if (request.getPreviousLog().getIndex() >= reply.getNextIndex()) {
            this.clearPendingRequests(reply.getNextIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSnapshot(SnapshotInfo snapshot) {
        LOG.info("{}: follower {}'s next index is {}, log's start index is {}, need to install snapshot", this.server.getId(), this.follower.getPeer(), this.follower.getNextIndex(), this.raftLog.getStartIndex());
        InstallSnapshotResponseHandler responseHandler = new InstallSnapshotResponseHandler();
        StreamObserver<RaftProtos.InstallSnapshotRequestProto> snapshotRequestObserver = null;
        String requestId = UUID.randomUUID().toString();
        try {
            snapshotRequestObserver = this.getClient().installSnapshot(responseHandler);
            for (RaftProtos.InstallSnapshotRequestProto request : new LogAppender.SnapshotRequestIter(snapshot, requestId)) {
                if (!this.isAppenderRunning()) break;
                snapshotRequestObserver.onNext(request);
                this.follower.updateLastRpcSendTime();
                responseHandler.addPending(request);
            }
            snapshotRequestObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.warn("{} failed to install snapshot {}. Exception: {}", this, snapshot.getFiles(), e);
            if (snapshotRequestObserver != null) {
                snapshotRequestObserver.onError(e);
            }
            return;
        }
        GrpcLogAppender grpcLogAppender = this;
        synchronized (grpcLogAppender) {
            while (this.isAppenderRunning() && !responseHandler.isDone()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (responseHandler.hasAllResponse()) {
            this.follower.setSnapshotIndex(snapshot.getTermIndex().getIndex());
            LOG.info("{}: install snapshot-{} successfully on follower {}", this.server.getId(), snapshot.getTermIndex().getIndex(), this.follower.getPeer());
        }
    }

    private class InstallSnapshotResponseHandler
    implements StreamObserver<RaftProtos.InstallSnapshotReplyProto> {
        private final Queue<Integer> pending;
        private final AtomicBoolean done = new AtomicBoolean(false);

        InstallSnapshotResponseHandler() {
            this.pending = new LinkedList<Integer>();
        }

        synchronized void addPending(RaftProtos.InstallSnapshotRequestProto request) {
            this.pending.offer(request.getRequestIndex());
        }

        synchronized void removePending(RaftProtos.InstallSnapshotReplyProto reply) {
            int index = this.pending.poll();
            Preconditions.assertTrue(index == reply.getRequestIndex());
        }

        boolean isDone() {
            return this.done.get();
        }

        void close() {
            this.done.set(true);
            GrpcLogAppender.this.notifyAppend();
        }

        synchronized boolean hasAllResponse() {
            return this.pending.isEmpty();
        }

        @Override
        public void onNext(RaftProtos.InstallSnapshotReplyProto reply) {
            LOG.debug("{} received {} response from {}", GrpcLogAppender.this.server.getId(), !GrpcLogAppender.this.firstResponseReceived ? "the first" : "a", GrpcLogAppender.this.follower.getPeer());
            GrpcLogAppender.this.follower.updateLastRpcResponseTime();
            if (!GrpcLogAppender.this.firstResponseReceived) {
                GrpcLogAppender.this.firstResponseReceived = true;
            }
            switch (reply.getResult()) {
                case SUCCESS: {
                    this.removePending(reply);
                    break;
                }
                case NOT_LEADER: {
                    GrpcLogAppender.this.checkResponseTerm(reply.getTerm());
                    break;
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!GrpcLogAppender.this.isAppenderRunning()) {
                LOG.info("{} is stopped", (Object)GrpcLogAppender.this);
                return;
            }
            LOG.info("{} got error when installing snapshot to {}, exception: {}", GrpcLogAppender.this.server.getId(), GrpcLogAppender.this.follower.getPeer(), t);
            GrpcLogAppender.this.resetClient(null);
            this.close();
        }

        @Override
        public void onCompleted() {
            LOG.info("{} stops sending snapshots to follower {}", (Object)GrpcLogAppender.this.server.getId(), (Object)GrpcLogAppender.this.follower);
            this.close();
        }
    }

    private class AppendLogResponseHandler
    implements StreamObserver<RaftProtos.AppendEntriesReplyProto> {
        private AppendLogResponseHandler() {
        }

        @Override
        public void onNext(RaftProtos.AppendEntriesReplyProto reply) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}<-{}: received {} reply {} ", GrpcLogAppender.this.server.getId(), GrpcLogAppender.this.follower.getPeer(), !GrpcLogAppender.this.firstResponseReceived ? "the first" : "a", ServerProtoUtils.toString(reply));
            }
            try {
                this.onNextImpl(reply);
            }
            catch (Throwable t) {
                LOG.error("Failed onNext " + reply, t);
            }
        }

        private void onNextImpl(RaftProtos.AppendEntriesReplyProto reply) {
            GrpcLogAppender.this.follower.updateLastRpcResponseTime();
            if (!GrpcLogAppender.this.firstResponseReceived) {
                GrpcLogAppender.this.firstResponseReceived = true;
            }
            switch (reply.getResult()) {
                case SUCCESS: {
                    GrpcLogAppender.this.onSuccess(reply);
                    break;
                }
                case NOT_LEADER: {
                    GrpcLogAppender.this.onNotLeader(reply);
                    break;
                }
                case INCONSISTENCY: {
                    GrpcLogAppender.this.onInconsistency(reply);
                    break;
                }
            }
            GrpcLogAppender.this.notifyAppend();
        }

        @Override
        public void onError(Throwable t) {
            if (!GrpcLogAppender.this.isAppenderRunning()) {
                LOG.info("{} is stopped", (Object)GrpcLogAppender.this);
                return;
            }
            GrpcUtil.warn(LOG, () -> GrpcLogAppender.this.server.getId() + ": Failed appendEntries to " + GrpcLogAppender.this.follower.getPeer(), t);
            long callId = GrpcUtil.getCallId(t);
            GrpcLogAppender.this.resetClient((RaftProtos.AppendEntriesRequestProto)GrpcLogAppender.this.pendingRequests.get(callId));
        }

        @Override
        public void onCompleted() {
            LOG.info("{}: follower {} response Completed", (Object)GrpcLogAppender.this.server.getId(), (Object)GrpcLogAppender.this.follower);
            GrpcLogAppender.this.resetClient(null);
        }
    }
}

