/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.client.GrpcClientStreamer;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.ProtoUtils;

public class GrpcOutputStream
extends OutputStream {
    private final byte[] buf;
    private int count;
    private final AtomicLong seqNum = new AtomicLong();
    private final ClientId clientId;
    private final GrpcClientStreamer streamer;
    private boolean closed = false;

    public GrpcOutputStream(RaftProperties prop, ClientId clientId, RaftGroup group, RaftPeerId leaderId, GrpcTlsConfig tlsConfig) {
        int bufferSize = GrpcConfigKeys.OutputStream.bufferSize(prop).getSizeInt();
        this.buf = new byte[bufferSize];
        this.count = 0;
        this.clientId = clientId;
        this.streamer = new GrpcClientStreamer(prop, group, leaderId, clientId, tlsConfig);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        this.buf[this.count++] = (byte)b;
        this.flushIfNecessary();
    }

    private void flushIfNecessary() throws IOException {
        if (this.count == this.buf.length) {
            this.flushToStreamer();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int toWrite;
        this.checkClosed();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int total = 0; total < len; total += toWrite) {
            toWrite = Math.min(len - total, this.buf.length - this.count);
            System.arraycopy(b, off + total, this.buf, this.count, toWrite);
            this.count += toWrite;
            this.flushIfNecessary();
        }
    }

    private void flushToStreamer() throws IOException {
        if (this.count > 0) {
            this.streamer.write(ProtoUtils.toByteString(this.buf, 0, this.count), this.seqNum.getAndIncrement());
            this.count = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        this.flushToStreamer();
        this.streamer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushToStreamer();
        this.streamer.close();
        this.closed = true;
    }

    public String toString() {
        return "GrpcOutputStream-" + this.clientId;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.toString() + " was closed.");
        }
    }
}

