/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.ServerNotReadyException;
import org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;

public interface GrpcUtil {
    public static final Metadata.Key<String> EXCEPTION_TYPE_KEY = Metadata.Key.of("exception-type", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> EXCEPTION_OBJECT_KEY = Metadata.Key.of("exception-object-bin", Metadata.BINARY_BYTE_MARSHALLER);
    public static final Metadata.Key<String> CALL_ID = Metadata.Key.of("call-id", Metadata.ASCII_STRING_MARSHALLER);

    public static StatusRuntimeException wrapException(Throwable t) {
        return GrpcUtil.wrapException(t, -1L);
    }

    public static StatusRuntimeException wrapException(Throwable t, long callId) {
        t = JavaUtils.unwrapCompletionException(t);
        Metadata trailers = new Metadata();
        trailers.put(EXCEPTION_TYPE_KEY, t.getClass().getCanonicalName());
        trailers.put(EXCEPTION_OBJECT_KEY, IOUtils.object2Bytes(t));
        if (callId > 0L) {
            trailers.put(CALL_ID, String.valueOf(callId));
        }
        return new StatusRuntimeException(Status.INTERNAL.withCause(t).withDescription(t.getMessage()), trailers);
    }

    public static Throwable unwrapThrowable(Throwable t) {
        IOException ioe;
        if (t instanceof StatusRuntimeException && (ioe = GrpcUtil.tryUnwrapException((StatusRuntimeException)t)) != null) {
            return ioe;
        }
        return t;
    }

    public static IOException unwrapException(StatusRuntimeException se) {
        IOException ioe = GrpcUtil.tryUnwrapException(se);
        return ioe != null ? ioe : new IOException(se);
    }

    public static IOException tryUnwrapException(StatusRuntimeException se) {
        String className;
        Status status;
        Metadata trailers = se.getTrailers();
        if (trailers == null) {
            return null;
        }
        byte[] bytes = trailers.get(EXCEPTION_OBJECT_KEY);
        if (bytes != null) {
            try {
                return IOUtils.bytes2Object(bytes, IOException.class);
            }
            catch (Exception e) {
                se.addSuppressed(e);
            }
        }
        if ((status = se.getStatus()) != null && (className = trailers.get(EXCEPTION_TYPE_KEY)) != null) {
            try {
                Class<?> clazz = Class.forName(className);
                Exception unwrapped = ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), status.getDescription(), se);
                return IOUtils.asIOException(unwrapped);
            }
            catch (Exception e) {
                se.addSuppressed(e);
                return new IOException(se);
            }
        }
        return null;
    }

    public static long getCallId(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            Metadata trailers = ((StatusRuntimeException)t).getTrailers();
            String callId = trailers.get(CALL_ID);
            return callId != null ? (long)Integer.parseInt(callId) : -1L;
        }
        return -1L;
    }

    public static IOException unwrapIOException(Throwable t) {
        IOException e = t instanceof StatusRuntimeException ? GrpcUtil.unwrapException((StatusRuntimeException)t) : IOUtils.asIOException(t);
        return e;
    }

    public static <REPLY extends RaftClientReply, REPLY_PROTO> void asyncCall(StreamObserver<REPLY_PROTO> responseObserver, CheckedSupplier<CompletableFuture<REPLY>, IOException> supplier, Function<REPLY, REPLY_PROTO> toProto) {
        try {
            supplier.get().whenCompleteAsync((reply, exception) -> {
                if (exception != null) {
                    responseObserver.onError(GrpcUtil.wrapException(exception));
                } else {
                    responseObserver.onNext(toProto.apply(reply));
                    responseObserver.onCompleted();
                }
            });
        }
        catch (Exception e) {
            responseObserver.onError(GrpcUtil.wrapException(e));
        }
    }

    public static void warn(Logger log, Supplier<String> message, Throwable t) {
        LogUtils.warn(log, message, GrpcUtil.unwrapThrowable(t), StatusRuntimeException.class, ServerNotReadyException.class);
    }
}

