/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.client.GrpcClientRpc;
import org.apache.ratis.grpc.server.GrpcLogAppender;
import org.apache.ratis.grpc.server.GrpcService;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.FollowerInfo;
import org.apache.ratis.server.impl.LeaderState;
import org.apache.ratis.server.impl.LogAppender;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerFactory;

public class GrpcFactory
implements ServerFactory,
ClientFactory {
    private final GrpcTlsConfig tlsConfig;

    public static Parameters newRaftParameters(GrpcTlsConfig conf) {
        Parameters p = new Parameters();
        GrpcConfigKeys.TLS.setConf(p, conf);
        return p;
    }

    public GrpcFactory(Parameters parameters) {
        this(GrpcConfigKeys.TLS.getConf(parameters));
    }

    public GrpcFactory(GrpcTlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public GrpcTlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    @Override
    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    @Override
    public LogAppender newLogAppender(RaftServerImpl server, LeaderState state, FollowerInfo f) {
        return new GrpcLogAppender(server, state, f);
    }

    @Override
    public GrpcService newRaftServerRpc(RaftServer server) {
        return ((GrpcService.Builder)GrpcService.newBuilder().setServer(server)).setTlsConfig(this.tlsConfig).build();
    }

    @Override
    public GrpcClientRpc newRaftClientRpc(ClientId clientId, RaftProperties properties) {
        return new GrpcClientRpc(clientId, properties, this.getTlsConfig());
    }
}

