/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.examples.filestore.FileStoreCommon;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TaskQueue;
import org.apache.ratis.util.function.CheckedFunction;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FileInfo {
    public static final Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    private final Path relativePath;

    FileInfo(Path relativePath) {
        this.relativePath = relativePath;
    }

    Path getRelativePath() {
        return this.relativePath;
    }

    long getSize() {
        throw new UnsupportedOperationException("File " + this.getRelativePath() + " size is unknown.");
    }

    void flush() throws IOException {
    }

    ByteString read(CheckedFunction<Path, Path, IOException> resolver, long offset, long length) throws IOException {
        this.flush();
        if (offset + length > this.getSize()) {
            throw new IOException("Failed to read: offset (=" + offset + " + length (=" + length + ") > size = " + this.getSize() + ", path=" + this.getRelativePath());
        }
        try (SeekableByteChannel in = Files.newByteChannel(resolver.apply(this.getRelativePath()), StandardOpenOption.READ);){
            ByteBuffer buffer = ByteBuffer.allocateDirect(FileStoreCommon.getChunkSize(length));
            in.position(offset).read(buffer);
            buffer.flip();
            ByteString byteString = ByteString.copyFrom(buffer);
            return byteString;
        }
    }

    UnderConstruction asUnderConstruction() {
        throw new UnsupportedOperationException("File " + this.getRelativePath() + " is not under construction.");
    }

    static class UnderConstruction
    extends FileInfo {
        private FileOut out;
        private volatile long writeSize;
        private volatile long committedSize;
        private volatile long flushSize;
        private final TaskQueue writeQueue = new TaskQueue("writeQueue");
        private final Map<Long, WriteInfo> writeInfos = new ConcurrentHashMap<Long, WriteInfo>();
        private final AtomicLong lastWriteIndex = new AtomicLong(-1L);

        UnderConstruction(Path relativePath) {
            super(relativePath);
        }

        @Override
        UnderConstruction asUnderConstruction() {
            return this;
        }

        @Override
        long getSize() {
            return this.committedSize;
        }

        CompletableFuture<Integer> submitCreate(CheckedFunction<Path, Path, IOException> resolver, ByteString data, boolean close, ExecutorService executor, RaftPeerId id, long index) {
            Supplier<String> name = () -> "create(" + this.getRelativePath() + ", " + close + ") @" + id + ":" + index;
            CheckedSupplier<Integer, IOException> task = LogUtils.newCheckedSupplier(LOG, () -> {
                if (this.out == null) {
                    this.out = new FileOut((Path)resolver.apply(this.getRelativePath()));
                }
                return this.write(0L, data, close);
            }, name);
            return this.submitWrite(task, executor, id, index);
        }

        CompletableFuture<Integer> submitWrite(long offset, ByteString data, boolean close, ExecutorService executor, RaftPeerId id, long index) {
            Supplier<String> name = () -> "write(" + this.getRelativePath() + ", " + offset + ", " + close + ") @" + id + ":" + index;
            CheckedSupplier<Integer, IOException> task = LogUtils.newCheckedSupplier(LOG, () -> this.write(offset, data, close), name);
            return this.submitWrite(task, executor, id, index);
        }

        private CompletableFuture<Integer> submitWrite(CheckedSupplier<Integer, IOException> task, ExecutorService executor, RaftPeerId id, long index) {
            CompletableFuture<Integer> f = this.writeQueue.submit(task, executor, e -> new IOException("Failed " + task, (Throwable)e));
            WriteInfo info = new WriteInfo(f, this.lastWriteIndex.getAndSet(index));
            CollectionUtils.putNew(index, info, this.writeInfos, () -> id + ":writeInfos");
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int write(long offset, ByteString data, boolean close) throws IOException {
            if (offset != this.writeSize) {
                throw new IOException("Offset/size mismatched: offset = " + offset + " != writeSize = " + this.writeSize + ", path=" + this.getRelativePath());
            }
            if (this.out == null) {
                throw new IOException("File output is not initialized, path=" + this.getRelativePath());
            }
            FileOut fileOut = this.out;
            synchronized (fileOut) {
                int n = 0;
                if (data != null) {
                    ByteBuffer buffer = data.asReadOnlyByteBuffer();
                    try {
                        while (buffer.remaining() > 0) {
                            n += this.out.write(buffer);
                        }
                    }
                    finally {
                        this.writeSize += (long)n;
                    }
                }
                if (close) {
                    this.out.close();
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void flush() throws IOException {
            if (this.flushSize >= this.committedSize) {
                return;
            }
            FileOut fileOut = this.out;
            synchronized (fileOut) {
                if (this.flushSize >= this.committedSize) {
                    return;
                }
                this.out.flush();
                this.flushSize = this.writeSize;
            }
        }

        CompletableFuture<Integer> submitCommit(long offset, int size, Function<UnderConstruction, ReadOnly> closeFunction, ExecutorService executor, RaftPeerId id, long index) {
            boolean close = closeFunction != null;
            Supplier<String> name = () -> "commit(" + this.getRelativePath() + ", " + offset + ", " + size + ", close? " + close + ") @" + id + ":" + index;
            WriteInfo info = this.writeInfos.get(index);
            if (info == null) {
                return JavaUtils.completeExceptionally(new IOException(name.get() + " is already committed."));
            }
            CheckedSupplier task = LogUtils.newCheckedSupplier(LOG, () -> {
                if (offset != this.committedSize) {
                    throw new IOException("Offset/size mismatched: offset = " + offset + " != committedSize = " + this.committedSize + ", path=" + this.getRelativePath());
                }
                if (this.committedSize + (long)size > this.writeSize) {
                    throw new IOException("Offset/size mismatched: committed (=" + this.committedSize + ") + size (=" + size + ") > writeSize = " + this.writeSize);
                }
                this.committedSize += (long)size;
                if (close) {
                    closeFunction.apply(this);
                    this.writeInfos.remove(index);
                }
                info.getCommitFuture().complete(size);
                return size;
            }, name);
            WriteInfo previous = this.writeInfos.remove(info.getPreviousIndex());
            CompletableFuture<Integer> previousCommit = previous != null ? previous.getCommitFuture() : CompletableFuture.completedFuture(0);
            return info.getWriteFuture().thenCombineAsync(previousCommit, (writeSize, previousCommitSize) -> {
                Preconditions.assertTrue(size == writeSize);
                try {
                    return (Integer)task.get();
                }
                catch (IOException e) {
                    throw new CompletionException("Failed " + task, e);
                }
            }, (Executor)executor);
        }
    }

    static class WriteInfo {
        private final CompletableFuture<Integer> writeFuture;
        private final CompletableFuture<Integer> commitFuture;
        private final long previousIndex;

        WriteInfo(CompletableFuture<Integer> writeFuture, long previousIndex) {
            this.writeFuture = writeFuture;
            this.commitFuture = new CompletableFuture();
            this.previousIndex = previousIndex;
        }

        CompletableFuture<Integer> getCommitFuture() {
            return this.commitFuture;
        }

        CompletableFuture<Integer> getWriteFuture() {
            return this.writeFuture;
        }

        long getPreviousIndex() {
            return this.previousIndex;
        }
    }

    static class FileOut
    implements Closeable {
        private final OutputStream out;
        private final WritableByteChannel channel;

        FileOut(Path p) throws IOException {
            this.out = FileUtils.createNewFile(p);
            this.channel = Channels.newChannel(this.out);
        }

        int write(ByteBuffer data) throws IOException {
            return this.channel.write(data);
        }

        void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
            this.out.close();
        }
    }

    static class ReadOnly
    extends FileInfo {
        private final long size;

        ReadOnly(UnderConstruction f) {
            super(f.getRelativePath());
            this.size = f.getSize();
        }

        @Override
        long getSize() {
            return this.size;
        }
    }
}

