/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.common;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Level;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.examples.arithmetic.cli.Arithmetic;
import org.apache.ratis.examples.common.SubCommandBase;
import org.apache.ratis.examples.filestore.cli.FileStore;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.util.LogUtils;

public class Runner {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("No command type specified: ");
            return;
        }
        List<SubCommandBase> commands = Runner.initializeCommands(args[0]);
        Runner runner = new Runner();
        if (commands == null) {
            System.err.println("Wrong command type: " + args[0]);
            return;
        }
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        JCommander.Builder builder = JCommander.newBuilder().addObject(runner);
        commands.forEach(command -> builder.addCommand(command.getClass().getSimpleName().toLowerCase(), command, new String[0]));
        JCommander jc = builder.build();
        try {
            jc.parse(newArgs);
            Optional<SubCommandBase> selectedCommand = commands.stream().filter(command -> command.getClass().getSimpleName().toLowerCase().equals(jc.getParsedCommand())).findFirst();
            if (selectedCommand.isPresent()) {
                selectedCommand.get().run();
            } else {
                jc.usage();
            }
        }
        catch (ParameterException exception) {
            System.err.println("Wrong parameters: " + exception.getMessage());
            jc.usage();
        }
    }

    private static List<SubCommandBase> initializeCommands(String command) {
        if (command.equals(FileStore.class.getSimpleName().toLowerCase())) {
            return FileStore.getSubCommands();
        }
        if (command.equals(Arithmetic.class.getSimpleName().toLowerCase())) {
            return Arithmetic.getSubCommands();
        }
        return null;
    }

    static {
        LogUtils.setLogLevel(RaftServerImpl.LOG, Level.DEBUG);
        LogUtils.setLogLevel(RaftClient.LOG, Level.DEBUG);
    }
}

