/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.expression;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.DoubleFunction;
import java.util.function.UnaryOperator;
import org.apache.ratis.examples.arithmetic.expression.DoubleValue;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.util.Preconditions;

public class UnaryExpression
implements Expression {
    static final BiFunction<Op, Expression, String> PREFIX_OP_TO_STRING = (op, e) -> op + "" + e;
    static final BiFunction<Op, Expression, String> POSTFIX_OP_TO_STRING = (op, e) -> e + "" + op;
    final Op op;
    final Expression expression;

    UnaryExpression(byte[] buf, int offset) {
        Preconditions.assertTrue(buf[offset] == Expression.Type.UNARY.byteValue());
        this.op = Op.valueOf(buf[offset + 1]);
        this.expression = Expression.Utils.bytes2Expression(buf, offset + 2);
    }

    public UnaryExpression(Op op, Expression expression) {
        this.op = op;
        this.expression = expression;
    }

    @Override
    public int toBytes(byte[] buf, int offset) {
        buf[offset] = Expression.Type.UNARY.byteValue();
        buf[offset + 1] = this.op.byteValue();
        int length = this.expression.toBytes(buf, offset + 2);
        return 2 + length;
    }

    @Override
    public int length() {
        return 2 + this.expression.length();
    }

    @Override
    public Double evaluate(Map<String, Double> variableMap) {
        double value = this.expression.evaluate(variableMap);
        switch (this.op) {
            case NEG: {
                return -value;
            }
            case SQRT: {
                return Math.sqrt(value);
            }
            case SQUARE: {
                return value * value;
            }
        }
        throw new AssertionError((Object)("Unexpected op value: " + this.op));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnaryExpression that = (UnaryExpression)o;
        return this.op == that.op && Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }

    public String toString() {
        return this.op.toString(this.expression);
    }

    public static enum Op implements UnaryOperator<Expression>,
    DoubleFunction<Expression>
    {
        NEG("~"),
        SQRT("\u221a"),
        SQUARE("^2", POSTFIX_OP_TO_STRING);

        final String symbol;
        final BiFunction<Op, Expression, String> stringFunction;
        static final Op[] VALUES;

        private Op(String symbol) {
            this(symbol, PREFIX_OP_TO_STRING);
        }

        private Op(String symbol, BiFunction<Op, Expression, String> stringFunction) {
            this.symbol = symbol;
            this.stringFunction = stringFunction;
        }

        byte byteValue() {
            return (byte)this.ordinal();
        }

        @Override
        public Expression apply(Expression e) {
            return new UnaryExpression(this, e);
        }

        @Override
        public Expression apply(double value) {
            return new UnaryExpression(this, new DoubleValue(value));
        }

        public String toString() {
            return this.symbol;
        }

        public String toString(Expression e) {
            return this.stringFunction.apply(this, e);
        }

        static Op valueOf(byte b) {
            Preconditions.assertTrue(b < VALUES.length);
            return VALUES[b];
        }

        public String getSymbol() {
            return this.symbol;
        }

        static {
            VALUES = Op.values();
        }
    }
}

