/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.examples.arithmetic.AssignmentMessage;
import org.apache.ratis.examples.arithmetic.cli.Client;
import org.apache.ratis.examples.arithmetic.expression.BinaryExpression;
import org.apache.ratis.examples.arithmetic.expression.DoubleValue;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.examples.arithmetic.expression.UnaryExpression;
import org.apache.ratis.examples.arithmetic.expression.Variable;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;

@Parameters(commandDescription="Assign value to a variable.")
public class Assign
extends Client {
    Pattern binaryOperationPattern = Pattern.compile("([a-z1-9]*)([\\*\\-/\\+])([a-z1-9]*)");
    Pattern unaryOperationPattern = Pattern.compile("([\u221a~])([a-z1-9]+)");
    @Parameter(names={"--name"}, description="Name of the variable to set", required=true)
    String name;
    @Parameter(names={"--value"}, description="Value to set", required=true)
    String value;

    @Override
    protected void operation(RaftClient client) throws IOException {
        RaftClientReply send = client.send(new AssignmentMessage(new Variable(this.name), this.createExpression(this.value)));
        System.out.println("Success: " + send.isSuccess());
        System.out.println("Response: " + send.getMessage().getClass());
    }

    @VisibleForTesting
    protected Expression createExpression(String value) {
        if (value.matches("\\d*(\\.\\d*)?")) {
            return new DoubleValue(Double.valueOf(value));
        }
        if (value.matches("[a-zA-Z]+")) {
            return new Variable(value);
        }
        Matcher binaryMatcher = this.binaryOperationPattern.matcher(value);
        Matcher unaryMatcher = this.unaryOperationPattern.matcher(value);
        if (binaryMatcher.matches()) {
            return this.createBinaryExpression(binaryMatcher);
        }
        if (unaryMatcher.matches()) {
            return this.createUnaryExpression(unaryMatcher);
        }
        throw new IllegalArgumentException("Invalid expression " + value + " Try something like: 'a+b' or '2'");
    }

    private Expression createBinaryExpression(Matcher binaryMatcher) {
        String operator = binaryMatcher.group(2);
        String firstElement = binaryMatcher.group(1);
        String secondElement = binaryMatcher.group(3);
        Optional<BinaryExpression.Op> selectedOp = Arrays.stream(BinaryExpression.Op.values()).filter(op -> op.getSymbol().equals(operator)).findAny();
        if (!selectedOp.isPresent()) {
            throw new IllegalArgumentException("Unknown binary operator: " + operator);
        }
        return new BinaryExpression(selectedOp.get(), this.createExpression(firstElement), this.createExpression(secondElement));
    }

    private Expression createUnaryExpression(Matcher binaryMatcher) {
        String operator = binaryMatcher.group(1);
        String element = binaryMatcher.group(2);
        Optional<UnaryExpression.Op> selectedOp = Arrays.stream(UnaryExpression.Op.values()).filter(op -> op.getSymbol().equals(operator)).findAny();
        if (!selectedOp.isPresent()) {
            throw new IllegalArgumentException("Unknown unary operator:" + operator);
        }
        return new UnaryExpression(selectedOp.get(), this.createExpression(element));
    }
}

