/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UnorderedAsync {
    public static final Logger LOG = LoggerFactory.getLogger(UnorderedAsync.class);

    public static CompletableFuture<RaftClientReply> send(RaftClientRequest.Type type, RaftClientImpl client) {
        long callId = RaftClientImpl.nextCallId();
        PendingUnorderedRequest pending = new PendingUnorderedRequest(() -> client.newRaftClientRequest(null, callId, null, type, null));
        UnorderedAsync.sendRequestWithRetry(pending, client);
        return pending.getReplyFuture().thenApply(reply -> RaftClientImpl.handleStateMachineException(reply, CompletionException::new));
    }

    public static void sendRequestWithRetry(RaftClientImpl.PendingClientRequest pending, RaftClientImpl client) {
        CompletableFuture<RaftClientReply> f = pending.getReplyFuture();
        if (f.isDone()) {
            return;
        }
        RaftClientRequest request = pending.newRequest();
        int attemptCount = pending.getAttemptCount();
        ClientId clientId = client.getId();
        LOG.debug("{}: attempt #{} send~ {}", clientId, attemptCount, request);
        client.getClientRpc().sendRequestAsyncUnordered(request).whenCompleteAsync((reply, e) -> {
            try {
                LOG.debug("{}: attempt #{} receive~ {}", clientId, attemptCount, reply);
                reply = client.handleNotLeaderException(request, (RaftClientReply)reply, false);
                if (reply != null) {
                    f.complete((RaftClientReply)reply);
                    return;
                }
                RetryPolicy retryPolicy = client.getRetryPolicy();
                if (!retryPolicy.shouldRetry(attemptCount)) {
                    f.completeExceptionally(RaftClientImpl.newRaftRetryFailureException(request, attemptCount, retryPolicy));
                    return;
                }
                if (e != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(clientId + ": attempt #" + attemptCount + " failed~ " + request, (Throwable)e);
                    } else {
                        LOG.debug("{}: attempt #{} failed {} with {}", clientId, attemptCount, request, e);
                    }
                    e = JavaUtils.unwrapCompletionException(e);
                    if (e instanceof IOException) {
                        if (e instanceof NotLeaderException) {
                            client.handleNotLeaderException(request, (NotLeaderException)e, false);
                        } else if (!(e instanceof GroupMismatchException)) {
                            client.handleIOException(request, (IOException)e, null, false);
                        }
                    } else if (!client.getClientRpc().handleException(request.getServerId(), (Throwable)e, false)) {
                        f.completeExceptionally((Throwable)e);
                        return;
                    }
                }
                LOG.debug("schedule retry for attempt #{}, policy={}, request={}", attemptCount, retryPolicy, request);
                client.getScheduler().onTimeout(retryPolicy.getSleepTime(), () -> UnorderedAsync.sendRequestWithRetry(pending, client), LOG, () -> clientId + ": Failed~ to retry " + request);
            }
            catch (Throwable t) {
                LOG.error(clientId + ": XXX Failed " + request, t);
                f.completeExceptionally(t);
            }
        });
    }

    public static class PendingUnorderedRequest
    extends RaftClientImpl.PendingClientRequest {
        private final Supplier<RaftClientRequest> requestConstructor;

        PendingUnorderedRequest(Supplier<RaftClientRequest> requestConstructor) {
            this.requestConstructor = requestConstructor;
        }

        @Override
        RaftClientRequest newRequestImpl() {
            return this.requestConstructor.get();
        }
    }
}

