/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.client.impl.UnorderedAsync;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.LeaderNotReadyException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RaftRetryFailureException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.SlidingWindow;
import org.apache.ratis.util.TimeoutScheduler;
import org.apache.ratis.util.function.FunctionUtils;

final class RaftClientImpl
implements RaftClient {
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();
    private final ClientId clientId;
    private final RaftClientRpc clientRpc;
    private final Collection<RaftPeer> peers;
    private final RaftGroupId groupId;
    private final RetryPolicy retryPolicy;
    private volatile RaftPeerId leaderId;
    private final ConcurrentMap<String, SlidingWindow.Client<PendingAsyncRequest, RaftClientReply>> slidingWindows = new ConcurrentHashMap<String, SlidingWindow.Client<PendingAsyncRequest, RaftClientReply>>();
    private final TimeoutScheduler scheduler;
    private final Semaphore asyncRequestSemaphore;

    static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    RaftClientImpl(ClientId clientId, RaftGroup group, RaftPeerId leaderId, RaftClientRpc clientRpc, RaftProperties properties, RetryPolicy retryPolicy) {
        this.clientId = clientId;
        this.clientRpc = clientRpc;
        this.peers = new ConcurrentLinkedQueue<RaftPeer>(group.getPeers());
        this.groupId = group.getGroupId();
        this.leaderId = leaderId != null ? leaderId : (!this.peers.isEmpty() ? this.peers.iterator().next().getId() : null);
        Preconditions.assertTrue(retryPolicy != null, "retry policy can't be null");
        this.retryPolicy = retryPolicy;
        this.asyncRequestSemaphore = new Semaphore(RaftClientConfigKeys.Async.maxOutstandingRequests(properties));
        this.scheduler = TimeoutScheduler.newInstance(RaftClientConfigKeys.Async.schedulerThreads(properties));
        clientRpc.addServers(this.peers);
    }

    @Override
    public ClientId getId() {
        return this.clientId;
    }

    RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    TimeoutScheduler getScheduler() {
        return this.scheduler;
    }

    private SlidingWindow.Client<PendingAsyncRequest, RaftClientReply> getSlidingWindow(RaftClientRequest request) {
        return this.getSlidingWindow(request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD) ? request.getServerId() : null);
    }

    private SlidingWindow.Client<PendingAsyncRequest, RaftClientReply> getSlidingWindow(RaftPeerId target) {
        String id = target != null ? target.toString() : "RAFT";
        return this.slidingWindows.computeIfAbsent(id, key -> new SlidingWindow.Client(this.getId() + "->" + key));
    }

    @Override
    public CompletableFuture<RaftClientReply> sendAsync(Message message) {
        return this.sendAsync(RaftClientRequest.writeRequestType(), message, null);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendReadOnlyAsync(Message message) {
        return this.sendAsync(RaftClientRequest.readRequestType(), message, null);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendStaleReadAsync(Message message, long minIndex, RaftPeerId server) {
        return this.sendAsync(RaftClientRequest.staleReadRequestType(minIndex), message, server);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendWatchAsync(long index, RaftProtos.ReplicationLevel replication) {
        return UnorderedAsync.send(RaftClientRequest.watchRequestType(index, replication), this);
    }

    private CompletableFuture<RaftClientReply> sendAsync(RaftClientRequest.Type type, Message message, RaftPeerId server) {
        if (!type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            Objects.requireNonNull(message, "message == null");
        }
        try {
            this.asyncRequestSemaphore.acquire();
        }
        catch (InterruptedException e2) {
            return JavaUtils.completeExceptionally(IOUtils.toInterruptedIOException("Interrupted when sending " + type + ", message=" + message, e2));
        }
        long callId = RaftClientImpl.nextCallId();
        LongFunction<PendingAsyncRequest> constructor = seqNum -> new PendingAsyncRequest(seqNum, slidingWindowEntry -> this.newRaftClientRequest(server, callId, message, type, (RaftProtos.SlidingWindowEntry)slidingWindowEntry));
        return ((CompletableFuture)this.getSlidingWindow(server).submitNewRequest(constructor, this::sendRequestWithRetryAsync).getReplyFuture().thenApply(reply -> RaftClientImpl.handleStateMachineException(reply, CompletionException::new))).whenComplete((r, e) -> this.asyncRequestSemaphore.release());
    }

    RaftClientRequest newRaftClientRequest(RaftPeerId server, long callId, Message message, RaftClientRequest.Type type, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        return new RaftClientRequest(this.clientId, server != null ? server : this.leaderId, this.groupId, callId, message, type, slidingWindowEntry);
    }

    @Override
    public RaftClientReply send(Message message) throws IOException {
        return this.send(RaftClientRequest.writeRequestType(), message, null);
    }

    @Override
    public RaftClientReply sendReadOnly(Message message) throws IOException {
        return this.send(RaftClientRequest.readRequestType(), message, null);
    }

    @Override
    public RaftClientReply sendStaleRead(Message message, long minIndex, RaftPeerId server) throws IOException {
        return this.send(RaftClientRequest.staleReadRequestType(minIndex), message, server);
    }

    @Override
    public RaftClientReply sendWatch(long index, RaftProtos.ReplicationLevel replication) throws IOException {
        return this.send(RaftClientRequest.watchRequestType(index, replication), null, null);
    }

    private RaftClientReply send(RaftClientRequest.Type type, Message message, RaftPeerId server) throws IOException {
        if (!type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            Objects.requireNonNull(message, "message == null");
        }
        long callId = RaftClientImpl.nextCallId();
        return this.sendRequestWithRetry(() -> this.newRaftClientRequest(server, callId, message, type, null));
    }

    @Override
    public RaftClientReply setConfiguration(RaftPeer[] peersInNewConf) throws IOException {
        Objects.requireNonNull(peersInNewConf, "peersInNewConf == null");
        long callId = RaftClientImpl.nextCallId();
        this.addServers(Arrays.stream(peersInNewConf));
        return this.sendRequestWithRetry(() -> new SetConfigurationRequest(this.clientId, this.leaderId, this.groupId, callId, peersInNewConf));
    }

    @Override
    public RaftClientReply groupAdd(RaftGroup newGroup, RaftPeerId server) throws IOException {
        Objects.requireNonNull(newGroup, "newGroup == null");
        Objects.requireNonNull(server, "server == null");
        long callId = RaftClientImpl.nextCallId();
        this.addServers(newGroup.getPeers().stream());
        return this.sendRequest(GroupManagementRequest.newAdd(this.clientId, server, callId, newGroup));
    }

    @Override
    public RaftClientReply groupRemove(RaftGroupId grpId, boolean deleteDirectory, RaftPeerId server) throws IOException {
        Objects.requireNonNull(this.groupId, "groupId == null");
        Objects.requireNonNull(server, "server == null");
        long callId = RaftClientImpl.nextCallId();
        return this.sendRequest(GroupManagementRequest.newRemove(this.clientId, server, callId, grpId, deleteDirectory));
    }

    @Override
    public GroupListReply getGroupList(RaftPeerId server) throws IOException {
        Objects.requireNonNull(server, "server == null");
        RaftClientReply reply = this.sendRequest(new GroupListRequest(this.clientId, server, this.groupId, RaftClientImpl.nextCallId()));
        Preconditions.assertTrue(reply instanceof GroupListReply, () -> "Unexpected reply: " + reply);
        return (GroupListReply)reply;
    }

    @Override
    public GroupInfoReply getGroupInfo(RaftGroupId raftGroupId, RaftPeerId server) throws IOException {
        Objects.requireNonNull(server, "server == null");
        RaftGroupId rgi = raftGroupId == null ? this.groupId : raftGroupId;
        RaftClientReply reply = this.sendRequest(new GroupInfoRequest(this.clientId, server, rgi, RaftClientImpl.nextCallId()));
        Preconditions.assertTrue(reply instanceof GroupInfoReply, () -> "Unexpected reply: " + reply);
        return (GroupInfoReply)reply;
    }

    private void addServers(Stream<RaftPeer> peersInNewConf) {
        this.clientRpc.addServers(peersInNewConf.filter(p -> !this.peers.contains(p))::iterator);
    }

    private void sendRequestWithRetryAsync(PendingAsyncRequest pending) {
        CompletableFuture<RaftClientReply> f = pending.getReplyFuture();
        if (f.isDone()) {
            return;
        }
        RaftClientRequest request = pending.newRequest();
        ((CompletableFuture)this.sendRequestAsync(request, pending.getAttemptCount()).thenAccept(reply -> {
            if (f.isDone()) {
                return;
            }
            if (reply == null) {
                LOG.debug("schedule* attempt #{} with policy {} for {}", pending.getAttemptCount(), this.retryPolicy, request);
                this.scheduler.onTimeout(this.retryPolicy.getSleepTime(), () -> this.getSlidingWindow(request).retry(pending, this::sendRequestWithRetryAsync), LOG, () -> "Failed* to retry " + request);
            } else {
                f.complete((RaftClientReply)reply);
            }
        })).exceptionally(FunctionUtils.consumerAsNullFunction(f::completeExceptionally));
    }

    private RaftClientReply sendRequestWithRetry(Supplier<RaftClientRequest> supplier) throws InterruptedIOException, StateMachineException, GroupMismatchException {
        int attemptCount = 0;
        RaftClientRequest request;
        RaftClientReply reply;
        while ((reply = this.sendRequest(request = supplier.get())) == null) {
            if (!this.retryPolicy.shouldRetry(attemptCount)) {
                return null;
            }
            try {
                this.retryPolicy.getSleepTime().sleep();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("retry policy=" + this.retryPolicy);
            }
            ++attemptCount;
        }
        return reply;
    }

    private CompletableFuture<RaftClientReply> sendRequestAsync(RaftClientRequest request, int attemptCount) {
        LOG.debug("{}: send* {}", (Object)this.clientId, (Object)request);
        return ((CompletableFuture)this.clientRpc.sendRequestAsync(request).thenApply(reply -> {
            LOG.debug("{}: receive* {}", (Object)this.clientId, reply);
            reply = this.handleNotLeaderException(request, (RaftClientReply)reply, true);
            if (reply != null) {
                this.getSlidingWindow(request).receiveReply(request.getSlidingWindowEntry().getSeqNum(), (RaftClientReply)reply, this::sendRequestWithRetryAsync);
            } else if (!this.retryPolicy.shouldRetry(attemptCount)) {
                this.handleAsyncRetryFailure(request, attemptCount);
            }
            return reply;
        })).exceptionally(e -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this.clientId + ": Failed* " + request, (Throwable)e);
            } else {
                LOG.debug("{}: Failed* {} with {}", this.clientId, request, e);
            }
            e = JavaUtils.unwrapCompletionException(e);
            if (e instanceof IOException && !(e instanceof GroupMismatchException)) {
                if (!this.retryPolicy.shouldRetry(attemptCount)) {
                    this.handleAsyncRetryFailure(request, attemptCount);
                } else {
                    this.handleIOException(request, (IOException)e, null, true);
                }
                return null;
            }
            this.failAllAsyncRequests(request, (Throwable)e);
            return null;
        });
    }

    static RaftRetryFailureException newRaftRetryFailureException(RaftClientRequest request, int attemptCount, RetryPolicy retryPolicy) {
        return new RaftRetryFailureException("Failed " + request + " for " + (attemptCount - 1) + " attempts with " + retryPolicy);
    }

    private void handleAsyncRetryFailure(RaftClientRequest request, int attemptCount) {
        RaftRetryFailureException rfe = RaftClientImpl.newRaftRetryFailureException(request, attemptCount, this.retryPolicy);
        this.failAllAsyncRequests(request, rfe);
    }

    private void failAllAsyncRequests(RaftClientRequest request, Throwable t) {
        this.getSlidingWindow(request).fail(request.getSlidingWindowEntry().getSeqNum(), t);
    }

    private RaftClientReply sendRequest(RaftClientRequest request) throws StateMachineException, GroupMismatchException {
        LOG.debug("{}: send {}", (Object)this.clientId, (Object)request);
        RaftClientReply reply = null;
        try {
            reply = this.clientRpc.sendRequest(request);
        }
        catch (GroupMismatchException gme) {
            throw gme;
        }
        catch (IOException ioe) {
            this.handleIOException(request, ioe, null, false);
        }
        LOG.debug("{}: receive {}", (Object)this.clientId, (Object)reply);
        reply = this.handleNotLeaderException(request, reply, false);
        reply = RaftClientImpl.handleStateMachineException(reply, Function.identity());
        return reply;
    }

    static <E extends Throwable> RaftClientReply handleStateMachineException(RaftClientReply reply, Function<StateMachineException, E> converter) throws E {
        StateMachineException sme;
        if (reply != null && (sme = reply.getStateMachineException()) != null) {
            throw (Throwable)converter.apply(sme);
        }
        return reply;
    }

    RaftClientReply handleNotLeaderException(RaftClientRequest request, RaftClientReply reply, boolean resetSlidingWindow) {
        if (reply == null) {
            return null;
        }
        NotLeaderException nle = reply.getNotLeaderException();
        if (nle == null) {
            return reply;
        }
        return this.handleNotLeaderException(request, nle, resetSlidingWindow);
    }

    RaftClientReply handleNotLeaderException(RaftClientRequest request, NotLeaderException nle, boolean resetSlidingWindow) {
        this.refreshPeers(Arrays.asList(nle.getPeers()));
        RaftPeerId newLeader = nle.getSuggestedLeader() == null ? null : nle.getSuggestedLeader().getId();
        this.handleIOException(request, nle, newLeader, resetSlidingWindow);
        return null;
    }

    private void refreshPeers(Collection<RaftPeer> newPeers) {
        if (newPeers != null && newPeers.size() > 0) {
            this.peers.clear();
            this.peers.addAll(newPeers);
            this.clientRpc.addServers(newPeers);
        }
    }

    void handleIOException(RaftClientRequest request, IOException ioe, RaftPeerId newLeader, boolean resetSlidingWindow) {
        boolean changeLeader;
        LOG.debug("{}: suggested new leader: {}. Failed {} with {}", this.clientId, newLeader, request, ioe);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stack trace", new Throwable("TRACE"));
        }
        if (resetSlidingWindow) {
            this.getSlidingWindow(request).resetFirstSeqNum();
        }
        if (ioe instanceof LeaderNotReadyException) {
            return;
        }
        RaftPeerId oldLeader = request.getServerId();
        RaftPeerId curLeader = request.getServerId();
        boolean stillLeader = oldLeader.equals(curLeader);
        if (newLeader == null && stillLeader) {
            newLeader = CollectionUtils.random(oldLeader, CollectionUtils.as(this.peers, RaftPeer::getId));
        }
        LOG.debug("{}: oldLeader={},  curLeader={}, newLeader{}", this.clientId, oldLeader, curLeader, newLeader);
        boolean bl = changeLeader = newLeader != null && stillLeader;
        if (changeLeader) {
            LOG.debug("{}: change Leader from {} to {}", this.clientId, oldLeader, newLeader);
            this.leaderId = newLeader;
        }
        this.clientRpc.handleException(oldLeader, ioe, changeLeader);
    }

    void assertAsyncRequestSemaphore(int expectedAvailablePermits, int expectedQueueLength) {
        Preconditions.assertTrue(this.asyncRequestSemaphore.availablePermits() == expectedAvailablePermits);
        Preconditions.assertTrue(this.asyncRequestSemaphore.getQueueLength() == expectedQueueLength);
    }

    void assertScheduler(int numThreads) {
        Preconditions.assertTrue(this.scheduler.getNumThreads() == numThreads);
    }

    long getCallId() {
        return CALL_ID_COUNTER.get();
    }

    @Override
    public RaftClientRpc getClientRpc() {
        return this.clientRpc;
    }

    @Override
    public void close() throws IOException {
        this.clientRpc.close();
    }

    static class PendingAsyncRequest
    extends PendingClientRequest
    implements SlidingWindow.ClientSideRequest<RaftClientReply> {
        private final Function<RaftProtos.SlidingWindowEntry, RaftClientRequest> requestConstructor;
        private final long seqNum;
        private volatile boolean isFirst = false;

        PendingAsyncRequest(long seqNum, Function<RaftProtos.SlidingWindowEntry, RaftClientRequest> requestConstructor) {
            this.seqNum = seqNum;
            this.requestConstructor = requestConstructor;
        }

        @Override
        RaftClientRequest newRequestImpl() {
            return this.requestConstructor.apply(ProtoUtils.toSlidingWindowEntry(this.seqNum, this.isFirst));
        }

        @Override
        public void setFirstRequest() {
            this.isFirst = true;
        }

        @Override
        public long getSeqNum() {
            return this.seqNum;
        }

        @Override
        public boolean hasReply() {
            return this.getReplyFuture().isDone();
        }

        @Override
        public void setReply(RaftClientReply reply) {
            this.getReplyFuture().complete(reply);
        }

        @Override
        public void fail(Throwable e) {
            this.getReplyFuture().completeExceptionally(e);
        }

        public String toString() {
            return "[seq=" + this.getSeqNum() + "]";
        }
    }

    static abstract class PendingClientRequest {
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();
        private final AtomicInteger attemptCount = new AtomicInteger();

        PendingClientRequest() {
        }

        abstract RaftClientRequest newRequestImpl();

        final RaftClientRequest newRequest() {
            this.attemptCount.incrementAndGet();
            return this.newRequestImpl();
        }

        CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        int getAttemptCount() {
            return this.attemptCount.get();
        }
    }
}

