/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public interface ClientProtoUtils {
    public static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(ByteString requestorId, ByteString replyId, RaftGroupId groupId, long callId, boolean success) {
        return RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(requestorId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(groupId)).setCallId(callId).setSuccess(success);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ByteString requesterId, ByteString replyId, RaftGroupId groupId, long callId, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        if (slidingWindowEntry == null) {
            slidingWindowEntry = RaftProtos.SlidingWindowEntry.getDefaultInstance();
        }
        return RaftProtos.RaftRpcRequestProto.newBuilder().setRequestorId(requesterId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(groupId)).setCallId(callId).setSlidingWindowEntry(slidingWindowEntry);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ClientId requesterId, RaftPeerId replyId, RaftGroupId groupId, long callId, RaftProtos.SlidingWindowEntry slidingWindowEntry) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(requesterId.toByteString(), replyId.toByteString(), groupId, callId, slidingWindowEntry);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftClientRequest request) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(request.getClientId(), request.getServerId(), request.getRaftGroupId(), request.getCallId(), request.getSlidingWindowEntry());
    }

    public static RaftClientRequest.Type toRaftClientRequestType(RaftProtos.RaftClientRequestProto p) {
        switch (p.getTypeCase()) {
            case WRITE: {
                return RaftClientRequest.Type.valueOf(p.getWrite());
            }
            case READ: {
                return RaftClientRequest.Type.valueOf(p.getRead());
            }
            case STALEREAD: {
                return RaftClientRequest.Type.valueOf(p.getStaleRead());
            }
            case WATCH: {
                return RaftClientRequest.Type.valueOf(p.getWatch());
            }
        }
        throw new IllegalArgumentException("Unexpected request type: " + p.getTypeCase() + " in request proto " + p);
    }

    public static RaftClientRequest toRaftClientRequest(RaftProtos.RaftClientRequestProto p) {
        RaftClientRequest.Type type = ClientProtoUtils.toRaftClientRequestType(p);
        RaftProtos.RaftRpcRequestProto request = p.getRpcRequest();
        return new RaftClientRequest(ClientId.valueOf(request.getRequestorId()), RaftPeerId.valueOf(request.getReplyId()), ProtoUtils.toRaftGroupId(request.getRaftGroupId()), request.getCallId(), ClientProtoUtils.toMessage(p.getMessage()), type, request.getSlidingWindowEntry());
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(RaftClientRequest request) {
        RaftProtos.RaftClientRequestProto.Builder b = RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        if (request.getMessage() != null) {
            b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(request.getMessage()));
        }
        RaftClientRequest.Type type = request.getType();
        switch (type.getTypeCase()) {
            case WRITE: {
                b.setWrite(type.getWrite());
                break;
            }
            case READ: {
                b.setRead(type.getRead());
                break;
            }
            case STALEREAD: {
                b.setStaleRead(type.getStaleRead());
                break;
            }
            case WATCH: {
                b.setWatch(type.getWatch());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type: " + request.getType() + " in request " + request);
            }
        }
        return b.build();
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, long seqNum, ByteString content) {
        return RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(clientId, serverId, groupId, callId, ProtoUtils.toSlidingWindowEntry(seqNum, false))).setWrite(RaftProtos.WriteRequestTypeProto.getDefaultInstance()).setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(content)).build();
    }

    public static RaftProtos.RaftClientReplyProto toRaftClientReplyProto(RaftClientReply reply) {
        RaftProtos.RaftClientReplyProto.Builder b = RaftProtos.RaftClientReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            b.setLogIndex(reply.getLogIndex());
            if (reply.getMessage() != null) {
                b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(reply.getMessage()));
            }
            ProtoUtils.addCommitInfos(reply.getCommitInfos(), i -> b.addCommitInfos((RaftProtos.CommitInfoProto)i));
            NotLeaderException nle = reply.getNotLeaderException();
            if (nle != null) {
                RaftProtos.NotLeaderExceptionProto.Builder nleBuilder = RaftProtos.NotLeaderExceptionProto.newBuilder();
                RaftPeer suggestedLeader = nle.getSuggestedLeader();
                if (suggestedLeader != null) {
                    nleBuilder.setSuggestedLeader(suggestedLeader.getRaftPeerProto());
                }
                nleBuilder.addAllPeersInConf(ProtoUtils.toRaftPeerProtos(Arrays.asList(nle.getPeers())));
                b.setNotLeaderException(nleBuilder.build());
            } else {
                StateMachineException sme = reply.getStateMachineException();
                if (sme != null) {
                    RaftProtos.StateMachineExceptionProto.Builder smeBuilder = RaftProtos.StateMachineExceptionProto.newBuilder();
                    Throwable t = sme.getCause() != null ? sme.getCause() : sme;
                    smeBuilder.setExceptionClassName(t.getClass().getName()).setErrorMsg(t.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString(t.getStackTrace()));
                    b.setStateMachineException(smeBuilder.build());
                }
            }
            NotReplicatedException nre = reply.getNotReplicatedException();
            if (nre != null) {
                RaftProtos.NotReplicatedExceptionProto.Builder nreBuilder = RaftProtos.NotReplicatedExceptionProto.newBuilder().setCallId(nre.getCallId()).setReplication(nre.getRequiredReplication()).setLogIndex(nre.getLogIndex());
                b.setNotReplicatedException(nreBuilder);
            }
        }
        return b.build();
    }

    public static RaftProtos.GroupListReplyProto toGroupListReplyProto(GroupListReply reply) {
        RaftProtos.GroupListReplyProto.Builder b = RaftProtos.GroupListReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getGroupIds() != null) {
                reply.getGroupIds().forEach(groupId -> b.addGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(groupId)));
            }
        }
        return b.build();
    }

    public static RaftProtos.GroupInfoReplyProto toGroupInfoReplyProto(GroupInfoReply reply) {
        RaftProtos.GroupInfoReplyProto.Builder b = RaftProtos.GroupInfoReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getRaftGroupId() != null) {
                b.setGroup(ProtoUtils.toRaftGroupProtoBuilder(reply.getGroup()));
                b.setIsRaftStorageHealthy(reply.isRaftStorageHealthy());
                b.setRole(reply.getRoleInfoProto());
                ProtoUtils.addCommitInfos(reply.getCommitInfos(), i -> b.addCommitInfos((RaftProtos.CommitInfoProto)i));
            }
        }
        return b.build();
    }

    public static RaftClientReply toRaftClientReply(RaftProtos.RaftClientReplyProto replyProto) {
        RaftException e;
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        if (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTLEADEREXCEPTION)) {
            RaftProtos.NotLeaderExceptionProto nleProto = replyProto.getNotLeaderException();
            RaftPeer suggestedLeader = nleProto.hasSuggestedLeader() ? ProtoUtils.toRaftPeer(nleProto.getSuggestedLeader()) : null;
            RaftPeer[] peers = ProtoUtils.toRaftPeerArray(nleProto.getPeersInConfList());
            e = new NotLeaderException(RaftPeerId.valueOf(rp.getReplyId()), suggestedLeader, peers);
        } else if (replyProto.getExceptionDetailsCase() == RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTREPLICATEDEXCEPTION) {
            RaftProtos.NotReplicatedExceptionProto nre = replyProto.getNotReplicatedException();
            e = new NotReplicatedException(nre.getCallId(), nre.getReplication(), nre.getLogIndex());
        } else if (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.STATEMACHINEEXCEPTION)) {
            RaftProtos.StateMachineExceptionProto smeProto = replyProto.getStateMachineException();
            e = ClientProtoUtils.wrapStateMachineException(RaftPeerId.valueOf(rp.getReplyId()), smeProto.getExceptionClassName(), smeProto.getErrorMsg(), smeProto.getStacktrace());
        } else {
            e = null;
        }
        ClientId clientId = ClientId.valueOf(rp.getRequestorId());
        RaftGroupId groupId = ProtoUtils.toRaftGroupId(rp.getRaftGroupId());
        return new RaftClientReply(clientId, RaftPeerId.valueOf(rp.getReplyId()), groupId, rp.getCallId(), rp.getSuccess(), ClientProtoUtils.toMessage(replyProto.getMessage()), e, replyProto.getLogIndex(), replyProto.getCommitInfosList());
    }

    public static GroupListReply toGroupListReply(RaftProtos.GroupListReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        ClientId clientId = ClientId.valueOf(rp.getRequestorId());
        RaftGroupId groupId = ProtoUtils.toRaftGroupId(rp.getRaftGroupId());
        List<RaftGroupId> groupInfos = replyProto.getGroupIdList().stream().map(ProtoUtils::toRaftGroupId).collect(Collectors.toList());
        return new GroupListReply(clientId, RaftPeerId.valueOf(rp.getReplyId()), groupId, rp.getCallId(), rp.getSuccess(), groupInfos);
    }

    public static GroupInfoReply toGroupInfoReply(RaftProtos.GroupInfoReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        ClientId clientId = ClientId.valueOf(rp.getRequestorId());
        RaftGroupId groupId = ProtoUtils.toRaftGroupId(rp.getRaftGroupId());
        RaftGroup raftGroup = ProtoUtils.toRaftGroup(replyProto.getGroup());
        RaftProtos.RoleInfoProto role = replyProto.getRole();
        boolean isRaftStorageHealthy = replyProto.getIsRaftStorageHealthy();
        return new GroupInfoReply(clientId, RaftPeerId.valueOf(rp.getReplyId()), groupId, rp.getCallId(), rp.getSuccess(), role, isRaftStorageHealthy, replyProto.getCommitInfosList(), raftGroup);
    }

    public static StateMachineException wrapStateMachineException(RaftPeerId serverId, String className, String errorMsg, ByteString stackTraceBytes) {
        StateMachineException sme;
        if (className == null) {
            sme = new StateMachineException(errorMsg);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Exception e = ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), errorMsg, null);
                sme = new StateMachineException(serverId, (Throwable)e);
            }
            catch (Exception e) {
                sme = new StateMachineException(className + ": " + errorMsg);
            }
        }
        StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject(stackTraceBytes);
        sme.setStackTrace(stacktrace);
        return sme;
    }

    public static Message toMessage(RaftProtos.ClientMessageEntryProto p) {
        return Message.valueOf(p.getContent());
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(ByteString message) {
        return RaftProtos.ClientMessageEntryProto.newBuilder().setContent(message);
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(Message message) {
        return ClientProtoUtils.toClientMessageEntryProtoBuilder(message.getContent());
    }

    public static SetConfigurationRequest toSetConfigurationRequest(RaftProtos.SetConfigurationRequestProto p) {
        RaftProtos.RaftRpcRequestProto m3 = p.getRpcRequest();
        RaftPeer[] peers = ProtoUtils.toRaftPeerArray(p.getPeersList());
        return new SetConfigurationRequest(ClientId.valueOf(m3.getRequestorId()), RaftPeerId.valueOf(m3.getReplyId()), ProtoUtils.toRaftGroupId(m3.getRaftGroupId()), p.getRpcRequest().getCallId(), peers);
    }

    public static RaftProtos.SetConfigurationRequestProto toSetConfigurationRequestProto(SetConfigurationRequest request) {
        return RaftProtos.SetConfigurationRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request)).addAllPeers(ProtoUtils.toRaftPeerProtos(Arrays.asList(request.getPeersInNewConf()))).build();
    }

    public static GroupManagementRequest toGroupManagementRequest(RaftProtos.GroupManagementRequestProto p) {
        RaftProtos.RaftRpcRequestProto m3 = p.getRpcRequest();
        ClientId clientId = ClientId.valueOf(m3.getRequestorId());
        RaftPeerId serverId = RaftPeerId.valueOf(m3.getReplyId());
        switch (p.getOpCase()) {
            case GROUPADD: {
                return GroupManagementRequest.newAdd(clientId, serverId, m3.getCallId(), ProtoUtils.toRaftGroup(p.getGroupAdd().getGroup()));
            }
            case GROUPREMOVE: {
                RaftProtos.GroupRemoveRequestProto remove = p.getGroupRemove();
                return GroupManagementRequest.newRemove(clientId, serverId, m3.getCallId(), ProtoUtils.toRaftGroupId(remove.getGroupId()), remove.getDeleteDirectory());
            }
        }
        throw new IllegalArgumentException("Unexpected op " + p.getOpCase() + " in " + p);
    }

    public static GroupInfoRequest toGroupInfoRequest(RaftProtos.GroupInfoRequestProto p) {
        RaftProtos.RaftRpcRequestProto m3 = p.getRpcRequest();
        return new GroupInfoRequest(ClientId.valueOf(m3.getRequestorId()), RaftPeerId.valueOf(m3.getReplyId()), ProtoUtils.toRaftGroupId(m3.getRaftGroupId()), m3.getCallId());
    }

    public static GroupListRequest toGroupListRequest(RaftProtos.GroupListRequestProto p) {
        RaftProtos.RaftRpcRequestProto m3 = p.getRpcRequest();
        return new GroupListRequest(ClientId.valueOf(m3.getRequestorId()), RaftPeerId.valueOf(m3.getReplyId()), ProtoUtils.toRaftGroupId(m3.getRaftGroupId()), m3.getCallId());
    }

    public static RaftProtos.GroupManagementRequestProto toGroupManagementRequestProto(GroupManagementRequest request) {
        GroupManagementRequest.Remove remove;
        RaftProtos.GroupManagementRequestProto.Builder b = RaftProtos.GroupManagementRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        GroupManagementRequest.Add add = request.getAdd();
        if (add != null) {
            b.setGroupAdd(RaftProtos.GroupAddRequestProto.newBuilder().setGroup(ProtoUtils.toRaftGroupProtoBuilder(add.getGroup())).build());
        }
        if ((remove = request.getRemove()) != null) {
            b.setGroupRemove(RaftProtos.GroupRemoveRequestProto.newBuilder().setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(remove.getGroupId())).setDeleteDirectory(remove.isDeleteDirectory()).build());
        }
        return b.build();
    }

    public static RaftProtos.GroupInfoRequestProto toGroupInfoRequestProto(GroupInfoRequest request) {
        return RaftProtos.GroupInfoRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request)).build();
    }

    public static RaftProtos.GroupListRequestProto toGroupListRequestProto(GroupListRequest request) {
        return RaftProtos.GroupListRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request)).build();
    }

    public static String toString(RaftProtos.RaftClientRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpc = proto.getRpcRequest();
        return ClientId.valueOf(rpc.getRequestorId()) + "->" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId() + "-" + ProtoUtils.toString(rpc.getSlidingWindowEntry());
    }

    public static String toString(RaftProtos.RaftClientReplyProto proto) {
        RaftProtos.RaftRpcReplyProto rpc = proto.getRpcReply();
        return ClientId.valueOf(rpc.getRequestorId()) + "<-" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId();
    }
}

