/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.MD5FileUtil;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotManager {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotManager.class);
    private final RaftStorage storage;
    private final RaftPeerId selfId;

    public SnapshotManager(RaftStorage storage, RaftPeerId selfId) throws IOException {
        this.storage = storage;
        this.selfId = selfId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installSnapshot(StateMachine stateMachine, RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        long lastIncludedIndex = request.getTermIndex().getIndex();
        RaftStorageDirectory dir = this.storage.getStorageDir();
        File tmpDir = dir.getNewTempDir();
        FileUtils.createDirectories((File)tmpDir);
        tmpDir.deleteOnExit();
        LOG.info("Installing snapshot:{}, to tmp dir:{}", (Object)request, (Object)tmpDir);
        for (RaftProtos.FileChunkProto chunk : request.getFileChunksList()) {
            SnapshotInfo pi = stateMachine.getLatestSnapshot();
            if (pi != null && pi.getTermIndex().getIndex() >= lastIncludedIndex) {
                throw new IOException("There exists snapshot file " + pi.getFiles() + " in " + this.selfId + " with endIndex >= lastIncludedIndex " + lastIncludedIndex);
            }
            String fileName = chunk.getFilename();
            File tmpSnapshotFile = new File(tmpDir, new File(dir.getRoot(), fileName).getName());
            FileOutputStream out = null;
            try {
                if (chunk.getOffset() == 0L) {
                    if (tmpSnapshotFile.exists()) {
                        FileUtils.deleteFully((File)tmpSnapshotFile);
                    }
                    out = new FileOutputStream(tmpSnapshotFile);
                } else {
                    Preconditions.assertTrue((boolean)tmpSnapshotFile.exists());
                    out = new FileOutputStream(tmpSnapshotFile, true);
                    FileChannel fc = out.getChannel();
                    fc.position(chunk.getOffset());
                }
                out.write(chunk.getData().toByteArray());
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            if (!chunk.getDone()) continue;
            MD5Hash expectedDigest = new MD5Hash(chunk.getFileDigest().toByteArray());
            MD5Hash digest = MD5FileUtil.computeMd5ForFile((File)tmpSnapshotFile);
            if (!digest.equals((Object)expectedDigest)) {
                LOG.warn("The snapshot md5 digest {} does not match expected {}", (Object)digest, (Object)expectedDigest);
                throw new IOException("MD5 mismatch for snapshot-" + lastIncludedIndex + " installation");
            }
            MD5FileUtil.saveMD5File((File)tmpSnapshotFile, (MD5Hash)digest);
        }
        if (request.getDone()) {
            LOG.info("Install snapshot is done, renaming tnp dir:{} to:{}", (Object)tmpDir, (Object)dir.getStateMachineDir());
            dir.getStateMachineDir().delete();
            tmpDir.renameTo(dir.getStateMachineDir());
        }
    }
}

