/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatchRequests {
    public static final Logger LOG = LoggerFactory.getLogger(WatchRequests.class);
    private final String name;
    private final Map<RaftProtos.ReplicationLevel, WatchQueue> queues = new EnumMap<RaftProtos.ReplicationLevel, WatchQueue>(RaftProtos.ReplicationLevel.class);
    private final TimeDuration watchTimeoutNanos;
    private final TimeDuration watchTimeoutDenominationNanos;
    private final TimeoutScheduler scheduler = TimeoutScheduler.newInstance((int)2);

    WatchRequests(Object name, RaftProperties properties) {
        this.name = name + "-" + this.getClass().getSimpleName();
        TimeDuration watchTimeout = RaftServerConfigKeys.watchTimeout(properties);
        this.watchTimeoutNanos = watchTimeout.to(TimeUnit.NANOSECONDS);
        TimeDuration watchTimeoutDenomination = RaftServerConfigKeys.watchTimeoutDenomination(properties);
        this.watchTimeoutDenominationNanos = watchTimeoutDenomination.to(TimeUnit.NANOSECONDS);
        Preconditions.assertTrue((this.watchTimeoutNanos.getDuration() % this.watchTimeoutDenominationNanos.getDuration() == 0L ? 1 : 0) != 0, () -> "watchTimeout (=" + watchTimeout + ") is not a multiple of watchTimeoutDenomination (=" + watchTimeoutDenomination + ").");
        Arrays.stream(RaftProtos.ReplicationLevel.values()).forEach(r -> this.queues.put((RaftProtos.ReplicationLevel)r, new WatchQueue((RaftProtos.ReplicationLevel)r)));
    }

    CompletableFuture<Void> add(RaftClientRequest request) {
        PendingWatch pending;
        RaftProtos.WatchRequestTypeProto watch = request.getType().getWatch();
        WatchQueue queue = this.queues.get(watch.getReplication());
        if (watch.getIndex() > queue.getIndex() && (pending = queue.add(request)) != null) {
            return pending.getFuture();
        }
        return CompletableFuture.completedFuture(null);
    }

    void update(RaftProtos.ReplicationLevel replication, long newIndex) {
        WatchQueue queue = this.queues.get(replication);
        if (newIndex > queue.getIndex()) {
            queue.updateIndex(newIndex);
        }
    }

    void failWatches(Exception e) {
        this.queues.values().forEach(q -> q.failAll(e));
    }

    private class WatchQueue {
        private final RaftProtos.ReplicationLevel replication;
        private final SortedMap<PendingWatch, PendingWatch> q = new TreeMap<PendingWatch, PendingWatch>(Comparator.comparingLong(PendingWatch::getIndex).thenComparing(PendingWatch::getCreationTime));
        private volatile long index;

        WatchQueue(RaftProtos.ReplicationLevel replication) {
            this.replication = replication;
        }

        long getIndex() {
            return this.index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PendingWatch add(RaftClientRequest request) {
            long currentTime = Timestamp.currentTimeNanos();
            long roundUp = WatchRequests.this.watchTimeoutDenominationNanos.roundUpNanos(currentTime);
            PendingWatch pending = new PendingWatch(request.getType().getWatch(), Timestamp.valueOf((long)roundUp));
            WatchQueue watchQueue = this;
            synchronized (watchQueue) {
                if (pending.getIndex() > this.getIndex()) {
                    PendingWatch previous = this.q.putIfAbsent(pending, pending);
                    if (previous != null) {
                        return previous;
                    }
                } else {
                    return null;
                }
            }
            TimeDuration timeout = WatchRequests.this.watchTimeoutNanos.apply(duration -> duration + roundUp - currentTime);
            WatchRequests.this.scheduler.onTimeout(timeout, () -> this.handleTimeout(request, pending), LOG, () -> WatchRequests.this.name + ": Failed to timeout " + request);
            return pending;
        }

        void handleTimeout(RaftClientRequest request, PendingWatch pending) {
            if (this.removeExisting(pending)) {
                pending.getFuture().completeExceptionally((Throwable)new NotReplicatedException(request.getCallId(), this.replication, pending.getIndex()));
                LOG.debug("{}: timeout {}, {}", new Object[]{WatchRequests.this.name, pending, request});
            }
        }

        synchronized boolean removeExisting(PendingWatch pending) {
            PendingWatch removed = (PendingWatch)this.q.remove(pending);
            if (removed == null) {
                return false;
            }
            Preconditions.assertTrue((removed == pending ? 1 : 0) != 0);
            return true;
        }

        synchronized void updateIndex(long newIndex) {
            if (newIndex <= this.getIndex()) {
                return;
            }
            LOG.debug("{}: update {} index from {} to {}", new Object[]{WatchRequests.this.name, this.replication, this.index, newIndex});
            this.index = newIndex;
            while (!this.q.isEmpty()) {
                PendingWatch first = this.q.firstKey();
                if (first.getIndex() > newIndex) {
                    return;
                }
                boolean removed = this.removeExisting(first);
                Preconditions.assertTrue((boolean)removed);
                LOG.debug("{}: complete {}", (Object)WatchRequests.this.name, (Object)first);
                first.getFuture().complete(null);
            }
        }

        synchronized void failAll(Exception e) {
            for (PendingWatch pending : this.q.values()) {
                pending.getFuture().completeExceptionally(e);
            }
            this.q.clear();
        }
    }

    static class PendingWatch {
        private final RaftProtos.WatchRequestTypeProto watch;
        private final Timestamp creationTime;
        private final Supplier<CompletableFuture<Void>> future = JavaUtils.memoize(CompletableFuture::new);

        PendingWatch(RaftProtos.WatchRequestTypeProto watch, Timestamp creationTime) {
            this.watch = watch;
            this.creationTime = creationTime;
        }

        CompletableFuture<Void> getFuture() {
            return this.future.get();
        }

        long getIndex() {
            return this.watch.getIndex();
        }

        Timestamp getCreationTime() {
            return this.creationTime;
        }

        public String toString() {
            return RaftClientRequest.Type.toString((RaftProtos.WatchRequestTypeProto)this.watch) + "@" + this.creationTime + "?" + StringUtils.completableFuture2String(this.future.get(), (boolean)true);
        }
    }
}

