/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.AlreadyClosedException;
import org.apache.ratis.protocol.AlreadyExistsException;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerFactory;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftServerProxy
implements RaftServer {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerProxy.class);
    private final RaftPeerId id;
    private final RaftProperties properties;
    private final StateMachine.Registry stateMachineRegistry;
    private final LifeCycle lifeCycle;
    private final RaftServerRpc serverRpc;
    private final ServerFactory factory;
    private ExecutorService implExecutor;
    private final ImplMap impls = new ImplMap();

    RaftServerProxy(RaftPeerId id, StateMachine.Registry stateMachineRegistry, RaftProperties properties, Parameters parameters) {
        this.properties = properties;
        this.stateMachineRegistry = stateMachineRegistry;
        RpcType rpcType = RaftConfigKeys.Rpc.type((RaftProperties)properties, arg_0 -> ((Logger)LOG).info(arg_0));
        this.factory = ServerFactory.cast(rpcType.newFactory(parameters));
        this.serverRpc = this.factory.newRaftServerRpc(this);
        this.id = id != null ? id : RaftPeerId.valueOf((String)RaftServerProxy.getIdStringFrom(this.serverRpc));
        this.lifeCycle = new LifeCycle((Object)(this.id + "-" + this.getClass().getSimpleName()));
        this.implExecutor = Executors.newSingleThreadExecutor();
    }

    void initGroups(RaftGroup group) {
        Optional<RaftGroup> raftGroup = Optional.ofNullable(group);
        Optional<RaftGroupId> raftGroupId = raftGroup.map(RaftGroup::getGroupId);
        RaftServerConfigKeys.storageDirs(this.properties).parallelStream().forEach(dir -> Optional.ofNullable(dir.listFiles()).map(Arrays::stream).orElse(Stream.empty()).filter(File::isDirectory).forEach(sub -> {
            try {
                LOG.info("{}: found a subdirectory {}", (Object)this.getId(), sub);
                RaftGroupId groupId = RaftGroupId.valueOf((UUID)UUID.fromString(sub.getName()));
                if (!raftGroupId.filter(arg_0 -> ((RaftGroupId)groupId).equals(arg_0)).isPresent()) {
                    this.addGroup(RaftGroup.valueOf((RaftGroupId)groupId, (RaftPeer[])new RaftPeer[0]));
                }
            }
            catch (Throwable t) {
                LOG.warn(this.getId() + ": Failed to initialize the group directory " + sub.getAbsolutePath() + ".  Ignoring it", t);
            }
        }));
        raftGroup.ifPresent(this::addGroup);
    }

    private CompletableFuture<RaftServerImpl> newRaftServerImpl(RaftGroup group) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.serverRpc.addPeers(group.getPeers());
                return new RaftServerImpl(group, (StateMachine)this.stateMachineRegistry.apply(group.getGroupId()), this);
            }
            catch (IOException e) {
                throw new CompletionException(this.getId() + ": Failed to initialize server for " + group, e);
            }
        }, this.implExecutor);
    }

    private static String getIdStringFrom(RaftServerRpc rpc) {
        InetSocketAddress address = null;
        try {
            address = rpc.getInetSocketAddress();
        }
        catch (Exception e) {
            LOG.warn("Failed to get InetSocketAddress from " + rpc.getRpcType() + " rpc server", (Throwable)e);
        }
        return address != null ? address.getHostName() + "_" + address.getPort() : rpc.getRpcType() + "-" + UUID.randomUUID();
    }

    @Override
    public RaftPeerId getId() {
        return this.id;
    }

    public List<RaftGroupId> getGroupIds() {
        return this.impls.getGroupIds();
    }

    @Override
    public Iterable<RaftGroup> getGroups() throws IOException {
        return this.getImpls().stream().map(RaftServerImpl::getGroup).collect(Collectors.toList());
    }

    public RpcType getRpcType() {
        return this.getFactory().getRpcType();
    }

    @Override
    public ServerFactory getFactory() {
        return this.factory;
    }

    @Override
    public RaftProperties getProperties() {
        return this.properties;
    }

    public RaftServerRpc getServerRpc() {
        return this.serverRpc;
    }

    public boolean containsGroup(RaftGroupId groupId) {
        return this.impls.containsGroup(groupId);
    }

    public CompletableFuture<RaftServerImpl> addGroup(RaftGroup group) {
        return this.impls.addNew(group);
    }

    private CompletableFuture<RaftServerImpl> getImplFuture(RaftGroupId groupId) {
        return this.impls.get(groupId);
    }

    private RaftServerImpl getImpl(RaftProtos.RaftRpcRequestProto proto) throws IOException {
        return this.getImpl(ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)proto.getRaftGroupId()));
    }

    public RaftServerImpl getImpl(RaftGroupId groupId) throws IOException {
        Objects.requireNonNull(groupId, "groupId == null");
        return (RaftServerImpl)IOUtils.getFromFuture(this.getImplFuture(groupId), this::getId);
    }

    List<RaftServerImpl> getImpls() throws IOException {
        ArrayList<RaftServerImpl> list = new ArrayList<RaftServerImpl>();
        for (CompletableFuture<RaftServerImpl> f : this.impls.getAll()) {
            list.add((RaftServerImpl)IOUtils.getFromFuture(f, this::getId));
        }
        return list;
    }

    @Override
    public LifeCycle.State getLifeCycleState() {
        return this.lifeCycle.getCurrentState();
    }

    @Override
    public void start() throws IOException {
        this.getImpls().parallelStream().forEach(RaftServerImpl::start);
        this.lifeCycle.startAndTransition(() -> {
            LOG.info("{}: start RPC server", (Object)this.getId());
            this.getServerRpc().start();
        }, new Class[]{IOException.class});
    }

    @Override
    public void close() {
        try {
            this.implExecutor.shutdown();
            this.implExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (Exception e) {
            LOG.warn(this.getId() + ": Failed to shutdown " + this.getRpcType() + " server");
        }
        this.lifeCycle.checkStateAndClose(() -> {
            LOG.info("{}: close", (Object)this.getId());
            this.impls.close();
            try {
                this.getServerRpc().close();
            }
            catch (IOException ignored) {
                LOG.warn(this.getId() + ": Failed to close " + this.getRpcType() + " server", (Throwable)ignored);
            }
        });
    }

    private <REPLY> CompletableFuture<REPLY> submitRequest(RaftGroupId groupId, CheckedFunction<RaftServerImpl, CompletableFuture<REPLY>, IOException> submitFunction) {
        return this.getImplFuture(groupId).thenCompose(impl -> (CompletableFuture)JavaUtils.callAsUnchecked(() -> (CompletableFuture)submitFunction.apply(impl), CompletionException::new));
    }

    public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) {
        return this.submitRequest(request.getRaftGroupId(), impl -> impl.submitClientRequestAsync(request));
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return this.getImpl(request.getRaftGroupId()).submitClientRequest(request);
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return this.getImpl(request.getRaftGroupId()).setConfiguration(request);
    }

    public RaftClientReply groupManagement(GroupManagementRequest request) throws IOException {
        return RaftServerImpl.waitForReply(this.getId(), (RaftClientRequest)request, this.groupManagementAsync(request), e -> new RaftClientReply((RaftClientRequest)request, e, null));
    }

    public CompletableFuture<RaftClientReply> groupManagementAsync(GroupManagementRequest request) {
        RaftGroupId groupId = request.getRaftGroupId();
        if (groupId == null) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Request group id == null"));
        }
        GroupManagementRequest.Add add = request.getAdd();
        if (add != null) {
            return this.groupAddAsync(request, add.getGroup());
        }
        GroupManagementRequest.Remove remove = request.getRemove();
        if (remove != null) {
            return this.groupRemoveAsync((RaftClientRequest)request, remove.getGroupId(), remove.isDeleteDirectory());
        }
        return JavaUtils.completeExceptionally((Throwable)new UnsupportedOperationException(this.getId() + ": Request not supported " + request));
    }

    private CompletableFuture<RaftClientReply> groupAddAsync(GroupManagementRequest request, RaftGroup newGroup) {
        if (!request.getRaftGroupId().equals((Object)newGroup.getGroupId())) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Request group id (" + request.getRaftGroupId() + ") does not match the new group " + newGroup));
        }
        return ((CompletableFuture)this.impls.addNew(newGroup).thenApplyAsync(newImpl -> {
            LOG.debug("{}: newImpl = {}", (Object)this.getId(), newImpl);
            boolean started = newImpl.start();
            Preconditions.assertTrue((boolean)started, () -> this.getId() + ": failed to start a new impl: " + newImpl);
            return new RaftClientReply((RaftClientRequest)request, newImpl.getCommitInfos());
        }, (Executor)this.implExecutor)).whenComplete((_1, throwable) -> {
            if (throwable != null) {
                this.impls.remove(newGroup.getGroupId());
                LOG.warn(this.getId() + ": Failed groupAdd* " + request, throwable);
            }
        });
    }

    private CompletableFuture<RaftClientReply> groupRemoveAsync(RaftClientRequest request, RaftGroupId groupId, boolean deleteDirectory) {
        if (!request.getRaftGroupId().equals((Object)groupId)) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Request group id (" + request.getRaftGroupId() + ") does not match the given group id " + groupId));
        }
        CompletableFuture<RaftServerImpl> f = this.impls.remove(groupId);
        if (f == null) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Group " + groupId + " not found."));
        }
        return f.thenApply(impl -> {
            Collection<RaftProtos.CommitInfoProto> commitInfos = impl.getCommitInfos();
            impl.shutdown(deleteDirectory);
            return new RaftClientReply(request, commitInfos);
        });
    }

    public GroupListReply getGroupList(GroupListRequest request) {
        return new GroupListReply((RaftClientRequest)request, (List)this.getGroupIds());
    }

    public CompletableFuture<GroupListReply> getGroupListAsync(GroupListRequest request) {
        return CompletableFuture.completedFuture(this.getGroupList(request));
    }

    public GroupInfoReply getGroupInfo(GroupInfoRequest request) throws IOException {
        return RaftServerImpl.waitForReply(this.getId(), (RaftClientRequest)request, this.getGroupInfoAsync(request), r -> null);
    }

    public CompletableFuture<GroupInfoReply> getGroupInfoAsync(GroupInfoRequest request) {
        return this.getImplFuture(request.getRaftGroupId()).thenApplyAsync(server -> server.getGroupInfo(request));
    }

    public CompletableFuture<RaftClientReply> setConfigurationAsync(SetConfigurationRequest request) {
        return this.submitRequest(request.getRaftGroupId(), impl -> impl.setConfigurationAsync(request));
    }

    @Override
    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        return this.getImpl(request.getServerRequest()).requestVote(request);
    }

    @Override
    public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto request) {
        RaftGroupId groupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getServerRequest().getRaftGroupId());
        return this.submitRequest(groupId, impl -> impl.appendEntriesAsync(request));
    }

    @Override
    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        return this.getImpl(request.getServerRequest()).appendEntries(request);
    }

    @Override
    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        return this.getImpl(request.getServerRequest()).installSnapshot(request);
    }

    public String toString() {
        return this.getId() + String.format(":%9s ", this.lifeCycle.getCurrentState()) + this.impls;
    }

    class ImplMap
    implements Closeable {
        private final ConcurrentMap<RaftGroupId, CompletableFuture<RaftServerImpl>> map = new ConcurrentHashMap<RaftGroupId, CompletableFuture<RaftServerImpl>>();
        private boolean isClosed = false;

        ImplMap() {
        }

        synchronized CompletableFuture<RaftServerImpl> addNew(RaftGroup group) {
            if (this.isClosed) {
                return JavaUtils.completeExceptionally((Throwable)new AlreadyClosedException(RaftServerProxy.this.getId() + ": Failed to add " + group + " since the server is already closed"));
            }
            if (this.containsGroup(group.getGroupId())) {
                return JavaUtils.completeExceptionally((Throwable)new AlreadyExistsException(RaftServerProxy.this.getId() + ": Failed to add " + group + " since the group already exists in the map."));
            }
            RaftGroupId groupId = group.getGroupId();
            CompletableFuture newImpl = RaftServerProxy.this.newRaftServerImpl(group);
            CompletableFuture<RaftServerImpl> previous = this.map.put(groupId, newImpl);
            Preconditions.assertNull(previous, (String)"previous");
            LOG.info("{}: addNew {} returns {}", new Object[]{RaftServerProxy.this.getId(), group, this.toString(groupId, newImpl)});
            return newImpl;
        }

        synchronized CompletableFuture<RaftServerImpl> remove(RaftGroupId groupId) {
            CompletableFuture future = (CompletableFuture)this.map.remove(groupId);
            LOG.info("{}: remove {}", (Object)RaftServerProxy.this.getId(), (Object)this.toString(groupId, future));
            return future;
        }

        @Override
        public synchronized void close() {
            if (this.isClosed) {
                LOG.info("{} is already closed.", (Object)RaftServerProxy.this.getId());
                return;
            }
            this.isClosed = true;
            this.map.values().parallelStream().map(CompletableFuture::join).forEach(impl -> impl.shutdown(false));
        }

        synchronized List<RaftGroupId> getGroupIds() {
            return new ArrayList<RaftGroupId>(this.map.keySet());
        }

        synchronized List<CompletableFuture<RaftServerImpl>> getAll() {
            return new ArrayList<CompletableFuture<RaftServerImpl>>(this.map.values());
        }

        CompletableFuture<RaftServerImpl> get(RaftGroupId groupId) {
            CompletableFuture i = (CompletableFuture)this.map.get(groupId);
            if (i == null) {
                return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(RaftServerProxy.this.getId() + ": " + groupId + " not found."));
            }
            return i;
        }

        boolean containsGroup(RaftGroupId groupId) {
            return this.map.containsKey(groupId);
        }

        public synchronized String toString() {
            if (this.map.isEmpty()) {
                return "<EMPTY>";
            }
            if (this.map.size() == 1) {
                return this.toString(this.map.entrySet().iterator().next());
            }
            StringBuilder b = new StringBuilder("[");
            this.map.entrySet().forEach(e -> b.append("\n  ").append(this.toString((Map.Entry<RaftGroupId, CompletableFuture<RaftServerImpl>>)e)));
            return b.append("] size=").append(this.map.size()).toString();
        }

        String toString(Map.Entry<RaftGroupId, CompletableFuture<RaftServerImpl>> e) {
            return this.toString(e.getKey(), e.getValue());
        }

        String toString(RaftGroupId groupId, CompletableFuture<RaftServerImpl> f) {
            return "" + (f != null && f.isDone() ? f.join() : groupId + ":" + f);
        }
    }
}

