/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;

public class TransactionContextImpl
implements TransactionContext {
    private final StateMachine stateMachine;
    private RaftClientRequest clientRequest;
    private Exception exception;
    private RaftProtos.SMLogEntryProto smLogEntryProto;
    private Object stateMachineContext;
    private boolean shouldCommit = true;
    private RaftProtos.LogEntryProto logEntry;

    private TransactionContextImpl(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public TransactionContextImpl(StateMachine stateMachine, RaftClientRequest clientRequest, RaftProtos.SMLogEntryProto smLogEntryProto) {
        this(stateMachine, clientRequest, smLogEntryProto, null);
    }

    public TransactionContextImpl(StateMachine stateMachine, RaftClientRequest clientRequest, RaftProtos.SMLogEntryProto smLogEntryProto, Object stateMachineContext) {
        this(stateMachine);
        this.clientRequest = clientRequest;
        this.smLogEntryProto = smLogEntryProto;
        this.stateMachineContext = stateMachineContext;
    }

    public TransactionContextImpl(StateMachine stateMachine, RaftClientRequest clientRequest, Exception exception) {
        this(stateMachine, clientRequest, exception, null);
    }

    public TransactionContextImpl(StateMachine stateMachine, RaftClientRequest clientRequest, Exception exception, Object stateMachineContext) {
        this(stateMachine);
        this.clientRequest = clientRequest;
        this.exception = exception;
        this.stateMachineContext = stateMachineContext;
    }

    public TransactionContextImpl(StateMachine stateMachine, RaftProtos.LogEntryProto logEntry) {
        this(stateMachine);
        this.setLogEntry(logEntry);
        this.smLogEntryProto = logEntry.getSmLogEntry();
    }

    @Override
    public RaftClientRequest getClientRequest() {
        return this.clientRequest;
    }

    @Override
    public RaftProtos.SMLogEntryProto getSMLogEntry() {
        return this.smLogEntryProto;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public TransactionContext setStateMachineContext(Object stateMachineContext) {
        this.stateMachineContext = stateMachineContext;
        return this;
    }

    @Override
    public Object getStateMachineContext() {
        return this.stateMachineContext;
    }

    @Override
    public TransactionContext setLogEntry(RaftProtos.LogEntryProto logEntry) {
        Objects.requireNonNull(logEntry, "logEntry == null");
        Preconditions.assertTrue((logEntry.getLogEntryBodyCase() == RaftProtos.LogEntryProto.LogEntryBodyCase.SMLOGENTRY ? 1 : 0) != 0, () -> "LogEntryBodyCase = " + logEntry.getLogEntryBodyCase() + " != " + RaftProtos.LogEntryProto.LogEntryBodyCase.SMLOGENTRY + ", logEntry=" + logEntry);
        Preconditions.assertTrue((this.logEntry == null ? 1 : 0) != 0, (Object)"this.logEntry != null");
        this.logEntry = logEntry;
        return this;
    }

    @Override
    public TransactionContext setSmLogEntryProto(RaftProtos.SMLogEntryProto smLogEntryProto) {
        this.smLogEntryProto = smLogEntryProto;
        return this;
    }

    @Override
    public RaftProtos.LogEntryProto getLogEntry() {
        return this.logEntry;
    }

    private TransactionContext setException(IOException ioe) {
        assert (this.exception != null);
        this.exception = ioe;
        return this;
    }

    @Override
    public TransactionContext setShouldCommit(boolean shouldCommit) {
        this.shouldCommit = shouldCommit;
        return this;
    }

    @Override
    public boolean shouldCommit() {
        return this.shouldCommit;
    }

    @Override
    public TransactionContext preAppendTransaction() throws IOException {
        return this.stateMachine.preAppendTransaction(this);
    }

    @Override
    public TransactionContext cancelTransaction() throws IOException {
        return this.stateMachine.cancelTransaction(this);
    }
}

