/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.shaded.com.google.protobuf.ByteString;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.TransactionContextImpl;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;

public class BaseStateMachine
implements StateMachine {
    private volatile RaftPeerId id;
    protected RaftProperties properties;
    protected RaftStorage storage;
    protected RaftConfiguration raftConf;
    protected final LifeCycle lifeCycle = new LifeCycle((Object)this.getClass().getSimpleName());
    private final AtomicReference<TermIndex> lastAppliedTermIndex = new AtomicReference();
    private final SortedMap<Long, CompletableFuture<Void>> transactionFutures = new TreeMap<Long, CompletableFuture<Void>>();

    public RaftPeerId getId() {
        return this.id;
    }

    @Override
    public LifeCycle.State getLifeCycleState() {
        return this.lifeCycle.getCurrentState();
    }

    @Override
    public void initialize(RaftPeerId id, RaftProperties properties, RaftStorage storage) throws IOException {
        this.id = id;
        this.lifeCycle.setName(this.getClass().getSimpleName() + ":" + id);
        this.properties = properties;
        this.storage = storage;
    }

    @Override
    public void setRaftConfiguration(RaftConfiguration conf) {
        this.raftConf = conf;
    }

    @Override
    public RaftConfiguration getRaftConfiguration() {
        return this.raftConf;
    }

    @Override
    public SnapshotInfo getLatestSnapshot() {
        return this.getStateMachineStorage().getLatestSnapshot();
    }

    @Override
    public void notifyNotLeader(Collection<TransactionContext> pendingEntries) throws IOException {
    }

    @Override
    public void pause() {
    }

    @Override
    public void reinitialize(RaftPeerId id, RaftProperties properties, RaftStorage storage) throws IOException {
    }

    @Override
    public TransactionContext applyTransactionSerial(TransactionContext trx) {
        return trx;
    }

    @Override
    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        return CompletableFuture.completedFuture(Message.valueOf((ByteString)trx.getLogEntry().getSmLogEntry().getData()));
    }

    @Override
    public TermIndex getLastAppliedTermIndex() {
        return this.lastAppliedTermIndex.get();
    }

    protected void setLastAppliedTermIndex(TermIndex newTI) {
        this.lastAppliedTermIndex.set(newTI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateLastAppliedTermIndex(long term, long index) {
        TermIndex oldTI;
        TermIndex newTI = TermIndex.newTermIndex(term, index);
        if (!newTI.equals(oldTI = this.lastAppliedTermIndex.getAndSet(newTI))) {
            LOG.debug("{}: update lastAppliedTermIndex from {} to {}", new Object[]{this.getId(), oldTI, newTI});
            if (oldTI != null) {
                Preconditions.assertTrue((newTI.compareTo(oldTI) >= 0 ? 1 : 0) != 0, () -> this.getId() + ": Failed updateLastAppliedTermIndex: newTI = " + newTI + " < oldTI = " + oldTI);
            }
            return true;
        }
        SortedMap<Long, CompletableFuture<Void>> sortedMap = this.transactionFutures;
        synchronized (sortedMap) {
            long i;
            while (!this.transactionFutures.isEmpty() && (i = this.transactionFutures.firstKey().longValue()) <= index) {
                ((CompletableFuture)this.transactionFutures.remove(i)).complete(null);
            }
        }
        return false;
    }

    @Override
    public long takeSnapshot() throws IOException {
        return -1L;
    }

    @Override
    public StateMachineStorage getStateMachineStorage() {
        return new StateMachineStorage(){

            @Override
            public void init(RaftStorage raftStorage) throws IOException {
            }

            @Override
            public SnapshotInfo getLatestSnapshot() {
                return null;
            }

            @Override
            public void format() throws IOException {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Message> queryStale(Message request, long minIndex) {
        if (this.getLastAppliedTermIndex().getIndex() < minIndex) {
            SortedMap<Long, CompletableFuture<Void>> sortedMap = this.transactionFutures;
            synchronized (sortedMap) {
                if (this.getLastAppliedTermIndex().getIndex() < minIndex) {
                    return this.transactionFutures.computeIfAbsent(minIndex, key -> new CompletableFuture()).thenCompose(v -> this.query(request));
                }
            }
        }
        return this.query(request);
    }

    @Override
    public CompletableFuture<Message> query(Message request) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        return new TransactionContextImpl((StateMachine)this, request, RaftProtos.SMLogEntryProto.newBuilder().setData(request.getMessage().getContent()).build());
    }

    @Override
    public TransactionContext cancelTransaction(TransactionContext trx) throws IOException {
        return trx;
    }

    @Override
    public TransactionContext preAppendTransaction(TransactionContext trx) throws IOException {
        return trx;
    }

    @Override
    public void close() throws IOException {
    }
}

