/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.ratis.server.impl.RaftServerConstants;
import org.apache.ratis.server.storage.MetaFile;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftStorage
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RaftStorage.class);
    private final RaftStorageDirectory storageDir;
    private final RaftStorageDirectory.StorageState state;
    private volatile MetaFile metaFile;
    private StateMachineStorage stateMachineStorage;

    public RaftStorage(File dir, RaftServerConstants.StartupOption option) throws IOException {
        this.storageDir = new RaftStorageDirectory(dir);
        if (option == RaftServerConstants.StartupOption.FORMAT) {
            if (this.storageDir.analyzeStorage(false) == RaftStorageDirectory.StorageState.NON_EXISTENT) {
                throw new IOException("Cannot format " + this.storageDir);
            }
            this.storageDir.lock();
            this.format();
            this.state = this.storageDir.analyzeStorage(false);
            Preconditions.assertTrue((this.state == RaftStorageDirectory.StorageState.NORMAL ? 1 : 0) != 0);
        } else {
            this.state = this.analyzeAndRecoverStorage(true);
            if (this.state != RaftStorageDirectory.StorageState.NORMAL) {
                this.storageDir.unlock();
                throw new IOException("Cannot load " + this.storageDir + ". Its state: " + (Object)((Object)this.state));
            }
        }
    }

    RaftStorageDirectory.StorageState getState() {
        return this.state;
    }

    private void format() throws IOException {
        this.storageDir.clearDirectory();
        this.metaFile = this.writeMetaFile(0L, "");
        LOG.info("Storage directory " + this.storageDir.getRoot() + " has been successfully formatted.");
    }

    private MetaFile writeMetaFile(long term, String votedFor) throws IOException {
        MetaFile metaFile = new MetaFile(this.storageDir.getMetaFile());
        metaFile.set(term, votedFor);
        return metaFile;
    }

    private void cleanMetaTmpFile() throws IOException {
        Files.deleteIfExists(this.storageDir.getMetaTmpFile().toPath());
    }

    private RaftStorageDirectory.StorageState analyzeAndRecoverStorage(boolean toLock) throws IOException {
        RaftStorageDirectory.StorageState storageState = this.storageDir.analyzeStorage(toLock);
        if (storageState == RaftStorageDirectory.StorageState.NORMAL) {
            this.metaFile = new MetaFile(this.storageDir.getMetaFile());
            Preconditions.assertTrue((boolean)this.metaFile.exists(), () -> "Meta file " + this.metaFile + " does not exists.");
            this.metaFile.readFile();
            this.cleanMetaTmpFile();
            return RaftStorageDirectory.StorageState.NORMAL;
        }
        if (storageState == RaftStorageDirectory.StorageState.NOT_FORMATTED && this.storageDir.isCurrentEmpty()) {
            this.format();
            return RaftStorageDirectory.StorageState.NORMAL;
        }
        return storageState;
    }

    public RaftStorageDirectory getStorageDir() {
        return this.storageDir;
    }

    @Override
    public void close() throws IOException {
        this.storageDir.unlock();
    }

    MetaFile getMetaFile() {
        return this.metaFile;
    }

    public SnapshotInfo getLastestSnapshot() throws IOException {
        return this.getStateMachineStorage().getLatestSnapshot();
    }

    public void setStateMachineStorage(StateMachineStorage smStorage) {
        this.stateMachineStorage = smStorage;
    }

    public StateMachineStorage getStateMachineStorage() {
        return this.stateMachineStorage;
    }

    public String toString() {
        return this.getStorageDir() + "";
    }
}

