/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftLogIOException;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RaftLog
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(RaftLog.class);
    public static final String LOG_SYNC = RaftLog.class.getSimpleName() + ".logSync";
    protected final AtomicLong lastCommitted = new AtomicLong(-1L);
    private final RaftPeerId selfId;
    private final int maxBufferSize;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private volatile boolean isOpen = false;

    public RaftLog(RaftPeerId selfId, int maxBufferSize) {
        this.selfId = selfId;
        this.maxBufferSize = maxBufferSize;
    }

    public long getLastCommittedIndex() {
        return this.lastCommitted.get();
    }

    public void checkLogState() {
        Preconditions.assertTrue((boolean)this.isOpen, (Object)"The RaftLog has not been opened or has been closed");
    }

    public boolean updateLastCommitted(long majorityIndex, long currentTerm) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            TermIndex entry;
            if (this.lastCommitted.get() < majorityIndex && (entry = this.getTermIndex(majorityIndex)) != null && entry.getTerm() == currentTerm) {
                LOG.debug("{}: Updating lastCommitted to {}", (Object)this.selfId, (Object)majorityIndex);
                this.lastCommitted.set(majorityIndex);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean contains(TermIndex ti) {
        if (ti == null) {
            return false;
        }
        TermIndex local = this.getTermIndex(ti.getIndex());
        return ti.equals(local);
    }

    public long getNextIndex() {
        TermIndex last = this.getLastEntryTermIndex();
        if (last == null) {
            return this.getLastCommittedIndex() + 1L;
        }
        return last.getIndex() + 1L;
    }

    public long append(long term, TransactionContext operation, ClientId clientId, long callId) throws StateMachineException {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            long nextIndex = this.getNextIndex();
            try {
                operation = operation.preAppendTransaction();
            }
            catch (IOException e) {
                throw new StateMachineException(this.selfId, (Throwable)e);
            }
            RaftProtos.LogEntryProto e = ProtoUtils.toLogEntryProto((RaftProtos.SMLogEntryProto)operation.getSMLogEntry(), (long)term, (long)nextIndex, (ClientId)clientId, (long)callId);
            int entrySize = e.getSerializedSize();
            if (entrySize > this.maxBufferSize) {
                throw new StateMachineException(this.selfId, (Throwable)((Object)new RaftLogIOException("Log entry size " + entrySize + " exceeds the max buffer limit of " + this.maxBufferSize)));
            }
            this.appendEntry(e);
            operation.setLogEntry(e);
            long l = nextIndex;
            return l;
        }
    }

    public long append(long term, RaftConfiguration newConf) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            long nextIndex = this.getNextIndex();
            RaftProtos.LogEntryProto e = ServerProtoUtils.toLogEntryProto(newConf, term, nextIndex);
            this.appendEntry(e);
            long l = nextIndex;
            return l;
        }
    }

    public void open(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> consumer) throws IOException {
        this.isOpen = true;
    }

    public abstract long getStartIndex();

    public abstract RaftProtos.LogEntryProto get(long var1) throws RaftLogIOException;

    public abstract TermIndex getTermIndex(long var1);

    public abstract TermIndex[] getEntries(long var1, long var3);

    public abstract TermIndex getLastEntryTermIndex();

    abstract CompletableFuture<Long> truncate(long var1);

    abstract CompletableFuture<Long> appendEntry(RaftProtos.LogEntryProto var1);

    public abstract List<CompletableFuture<Long>> append(RaftProtos.LogEntryProto ... var1);

    public abstract long getLatestFlushedIndex();

    public abstract void writeMetadata(long var1, RaftPeerId var3) throws IOException;

    public abstract Metadata loadMetadata() throws IOException;

    public abstract void syncWithSnapshot(long var1);

    public abstract boolean isConfigEntry(TermIndex var1);

    public String toString() {
        if (!this.isOpen) {
            return "Closed log";
        }
        TermIndex last = this.getLastEntryTermIndex();
        return last == null ? "null" : Collections.singletonList(last).toString();
    }

    public AutoCloseableLock readLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.readLock());
    }

    public AutoCloseableLock writeLock() {
        return AutoCloseableLock.acquire((Lock)this.lock.writeLock());
    }

    public boolean hasWriteLock() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public boolean hasReadLock() {
        return this.lock.getReadHoldCount() > 0 || this.hasWriteLock();
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    public RaftPeerId getSelfId() {
        return this.selfId;
    }

    public static class Metadata {
        private final RaftPeerId votedFor;
        private final long term;

        public Metadata(RaftPeerId votedFor, long term) {
            this.votedFor = votedFor;
            this.term = term;
        }

        public RaftPeerId getVotedFor() {
            return this.votedFor;
        }

        public long getTerm() {
            return this.term;
        }
    }
}

