/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftLog;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

public class MemoryRaftLog
extends RaftLog {
    private final List<RaftProtos.LogEntryProto> entries = new ArrayList<RaftProtos.LogEntryProto>();

    public MemoryRaftLog(RaftPeerId selfId, int maxBufferSize) {
        super(selfId, maxBufferSize);
    }

    @Override
    public RaftProtos.LogEntryProto get(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            int i = (int)index;
            RaftProtos.LogEntryProto logEntryProto = i >= 0 && i < this.entries.size() ? this.entries.get(i) : null;
            return logEntryProto;
        }
    }

    @Override
    public TermIndex getTermIndex(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            int i = (int)index;
            TermIndex termIndex = i >= 0 && i < this.entries.size() ? ServerProtoUtils.toTermIndex(this.entries.get(i)) : null;
            return termIndex;
        }
    }

    @Override
    public TermIndex[] getEntries(long startIndex, long endIndex) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            int from = (int)startIndex;
            if (startIndex >= (long)this.entries.size()) {
                TermIndex[] termIndexArray = null;
                return termIndexArray;
            }
            int to = (int)Math.min((long)this.entries.size(), endIndex);
            TermIndex[] ti = new TermIndex[to - from];
            for (int i = 0; i < ti.length; ++i) {
                ti[i] = TermIndex.newTermIndex(this.entries.get(i).getTerm(), this.entries.get(i).getIndex());
            }
            TermIndex[] termIndexArray = ti;
            return termIndexArray;
        }
    }

    @Override
    CompletableFuture<Long> truncate(long index) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            Preconditions.assertTrue((index >= 0L ? 1 : 0) != 0);
            int truncateIndex = (int)index;
            for (int i = this.entries.size() - 1; i >= truncateIndex; --i) {
                this.entries.remove(i);
            }
        }
        return CompletableFuture.completedFuture(index);
    }

    @Override
    public TermIndex getLastEntryTermIndex() {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            int size = this.entries.size();
            TermIndex termIndex = size == 0 ? null : ServerProtoUtils.toTermIndex(this.entries.get(size - 1));
            return termIndex;
        }
    }

    @Override
    CompletableFuture<Long> appendEntry(RaftProtos.LogEntryProto entry) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            this.entries.add(entry);
        }
        return CompletableFuture.completedFuture(entry.getIndex());
    }

    @Override
    public long append(long term, RaftConfiguration newConf) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            long nextIndex = this.getNextIndex();
            RaftProtos.LogEntryProto e = ServerProtoUtils.toLogEntryProto(newConf, term, nextIndex);
            this.entries.add(e);
            long l = nextIndex;
            return l;
        }
    }

    @Override
    public long getStartIndex() {
        return this.entries.isEmpty() ? -1L : this.entries.get(0).getIndex();
    }

    @Override
    public List<CompletableFuture<Long>> append(RaftProtos.LogEntryProto ... entries) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            ArrayList<CompletableFuture<Long>> futures;
            if (entries == null || entries.length == 0) {
                List<CompletableFuture<Long>> list = Collections.emptyList();
                return list;
            }
            boolean toTruncate = false;
            int truncateIndex = (int)entries[0].getIndex();
            int index = 0;
            while ((long)truncateIndex < this.getNextIndex() && index < entries.length) {
                if (this.entries.get(truncateIndex).getTerm() != entries[index].getTerm()) {
                    toTruncate = true;
                    break;
                }
                ++index;
                ++truncateIndex;
            }
            if (toTruncate) {
                futures = new ArrayList(entries.length - index + 1);
                futures.add(this.truncate(truncateIndex));
            } else {
                futures = new ArrayList<CompletableFuture<Long>>(entries.length - index);
            }
            for (int i = index; i < entries.length; ++i) {
                this.entries.add(entries[i]);
                futures.add(CompletableFuture.completedFuture(entries[i].getIndex()));
            }
            ArrayList<CompletableFuture<Long>> arrayList = futures;
            return arrayList;
        }
    }

    @Override
    public String toString() {
        return "last=" + this.getLastEntryTermIndex() + ", committed=" + ServerProtoUtils.toString(this.get(this.getLastCommittedIndex()));
    }

    public String getEntryString() {
        return "entries=" + this.entries;
    }

    @Override
    public long getLatestFlushedIndex() {
        return this.getNextIndex() - 1L;
    }

    @Override
    public void writeMetadata(long term, RaftPeerId votedFor) {
    }

    @Override
    public RaftLog.Metadata loadMetadata() {
        return new RaftLog.Metadata(null, 0L);
    }

    @Override
    public void syncWithSnapshot(long lastSnapshotIndex) {
    }

    @Override
    public boolean isConfigEntry(TermIndex ti) {
        return ProtoUtils.isConfigurationLogEntry((RaftProtos.LogEntryProto)this.get(ti.getIndex()));
    }
}

