/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;

public class ServerImplUtils {
    public static RaftServerProxy newRaftServer(RaftPeerId id, RaftGroup group, StateMachine stateMachine, RaftProperties properties, Parameters parameters) throws IOException {
        return ServerImplUtils.newRaftServer(id, group, gid -> stateMachine, properties, parameters);
    }

    public static RaftServerProxy newRaftServer(RaftPeerId id, RaftGroup group, StateMachine.Registry stateMachineRegistry, RaftProperties properties, Parameters parameters) throws IOException {
        RaftServerProxy proxy;
        try {
            proxy = (RaftServerProxy)JavaUtils.attempt(() -> new RaftServerProxy(id, stateMachineRegistry, group, properties, parameters), (int)5, (long)500L, (String)"new RaftServerProxy", (Logger)RaftServerProxy.LOG);
        }
        catch (InterruptedException e) {
            throw IOUtils.toInterruptedIOException((String)("Interrupted when creating RaftServer " + id + ", " + group), (InterruptedException)e);
        }
        catch (IOException e) {
            throw new IOException("Failed to create RaftServer " + id + ", " + group, e);
        }
        if (!group.getPeers().isEmpty()) {
            proxy.getServerRpc().addPeers(group.getPeers());
        }
        return proxy;
    }

    public static TermIndex newTermIndex(long term, long index) {
        return new TermIndexImpl(term, index);
    }

    private static class TermIndexImpl
    implements TermIndex {
        private final long term;
        private final long index;

        TermIndexImpl(long term, long logIndex) {
            this.term = term;
            this.index = logIndex;
        }

        @Override
        public long getTerm() {
            return this.term;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        @Override
        public int compareTo(TermIndex that) {
            int d = Long.compare(this.getTerm(), that.getTerm());
            return d != 0 ? d : Long.compare(this.getIndex(), that.getIndex());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof TermIndexImpl)) {
                return false;
            }
            TermIndexImpl that = (TermIndexImpl)obj;
            return this.getTerm() == that.getTerm() && this.getIndex() == that.getIndex();
        }

        public int hashCode() {
            return Long.hashCode(this.term) ^ Long.hashCode(this.index);
        }

        public String toString() {
            return TermIndex.toString(this.term, this.index);
        }
    }
}

