/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.ReinitializeRequest;
import org.apache.ratis.protocol.ServerInformationReply;
import org.apache.ratis.protocol.ServerInformationRequest;
import org.apache.ratis.protocol.ServerNotReadyException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerFactory;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftServerProxy
implements RaftServer {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerProxy.class);
    private final RaftPeerId id;
    private final RaftProperties properties;
    private final StateMachine.Registry stateMachineRegistry;
    private final RaftServerRpc serverRpc;
    private final ServerFactory factory;
    private volatile CompletableFuture<RaftServerImpl> impl;
    private final AtomicReference<ReinitializeRequest> reinitializeRequest = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RaftServerProxy(RaftPeerId id, StateMachine.Registry stateMachineRegistry, RaftGroup group, RaftProperties properties, Parameters parameters) throws IOException {
        this.properties = properties;
        this.stateMachineRegistry = stateMachineRegistry;
        RpcType rpcType = RaftConfigKeys.Rpc.type((RaftProperties)properties);
        this.factory = ServerFactory.cast(rpcType.newFactory(parameters));
        this.serverRpc = this.factory.newRaftServerRpc(this);
        this.id = id != null ? id : RaftPeerId.valueOf((String)RaftServerProxy.getIdStringFrom(this.serverRpc));
        try {
            this.impl = CompletableFuture.completedFuture(this.initImpl(group));
        }
        catch (IOException ioe) {
            try {
                this.serverRpc.close();
            }
            catch (IOException closeIoe) {
                LOG.warn(this.id + ": Failed to close server rpc.", (Throwable)closeIoe);
                ioe.addSuppressed(closeIoe);
            }
            finally {
                throw ioe;
            }
        }
    }

    private RaftServerImpl initImpl(RaftGroup group) throws IOException {
        return new RaftServerImpl(group, (StateMachine)this.stateMachineRegistry.apply(group.getGroupId()), this);
    }

    private static String getIdStringFrom(RaftServerRpc rpc) {
        InetSocketAddress address = null;
        try {
            address = rpc.getInetSocketAddress();
        }
        catch (Exception e) {
            LOG.warn("Failed to get InetSocketAddress from " + rpc.getRpcType() + " rpc server", (Throwable)e);
        }
        return address != null ? address.getHostName() + "_" + address.getPort() : rpc.getRpcType() + "-" + UUID.randomUUID();
    }

    @Override
    public RaftPeerId getId() {
        return this.id;
    }

    public RpcType getRpcType() {
        return this.getFactory().getRpcType();
    }

    @Override
    public ServerFactory getFactory() {
        return this.factory;
    }

    @Override
    public RaftProperties getProperties() {
        return this.properties;
    }

    public RaftServerRpc getServerRpc() {
        return this.serverRpc;
    }

    public RaftServerImpl getImpl() throws IOException {
        CompletableFuture<RaftServerImpl> i = this.impl;
        if (i == null) {
            throw new ServerNotReadyException(this.getId() + " is not initialized.");
        }
        try {
            return i.get();
        }
        catch (InterruptedException e) {
            throw IOUtils.toInterruptedIOException((String)(this.getId() + ": getImpl interrupted."), (InterruptedException)e);
        }
        catch (ExecutionException e) {
            throw IOUtils.asIOException((Throwable)e);
        }
    }

    @Override
    public void start() {
        LOG.info("{}: start", (Object)this.getId());
        JavaUtils.getAndConsume(this.impl, RaftServerImpl::start);
        this.getServerRpc().start();
    }

    @Override
    public void close() {
        LOG.info("{}: close", (Object)this.getId());
        JavaUtils.getAndConsume(this.impl, RaftServerImpl::shutdown);
        try {
            this.getServerRpc().close();
        }
        catch (IOException ignored) {
            LOG.warn("Failed to close RPC server for " + this.getId(), (Throwable)ignored);
        }
    }

    public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) throws IOException {
        return this.getImpl().submitClientRequestAsync(request);
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return this.getImpl().submitClientRequest(request);
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return this.getImpl().setConfiguration(request);
    }

    public RaftClientReply reinitialize(ReinitializeRequest request) throws IOException {
        return RaftServerImpl.waitForReply(this.getId(), (RaftClientRequest)request, this.reinitializeAsync(request), e -> new RaftClientReply((RaftClientRequest)request, e, null));
    }

    public CompletableFuture<RaftClientReply> reinitializeAsync(ReinitializeRequest request) throws IOException {
        LOG.info("{}: reinitializeAsync {}", (Object)this.getId(), (Object)request);
        this.getImpl().assertGroup(request.getRequestorId(), request.getRaftGroupId());
        if (!this.reinitializeRequest.compareAndSet(null, request)) {
            throw new IOException("Another reinitialize is already in progress.");
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                RaftServerImpl newImpl;
                CompletableFuture<RaftServerImpl> oldImpl = this.impl;
                this.impl = new CompletableFuture();
                JavaUtils.getAndConsume(oldImpl, RaftServerImpl::shutdown);
                try {
                    newImpl = this.initImpl(request.getGroup());
                }
                catch (IOException ioe) {
                    RaftException re = new RaftException("Failed to reinitialize, request=" + request, (Throwable)ioe);
                    this.impl.completeExceptionally(new IOException("Server " + this.getId() + " is not initialized.", (Throwable)re));
                    RaftClientReply raftClientReply = new RaftClientReply((RaftClientRequest)request, re, null);
                    this.reinitializeRequest.set(null);
                    return raftClientReply;
                }
                this.getServerRpc().addPeers(request.getGroup().getPeers());
                newImpl.start();
                this.impl.complete(newImpl);
                RaftClientReply raftClientReply = new RaftClientReply((RaftClientRequest)request, newImpl.getCommitInfos());
                return raftClientReply;
            }
            finally {
                this.reinitializeRequest.set(null);
            }
        });
    }

    public ServerInformationReply getInfo(ServerInformationRequest request) throws IOException {
        return RaftServerImpl.waitForReply(this.getId(), (RaftClientRequest)request, this.getInfoAsync(request), r -> null);
    }

    public CompletableFuture<ServerInformationReply> getInfoAsync(ServerInformationRequest request) {
        return this.impl.thenApply(server -> server.getServerInformation(request));
    }

    public CompletableFuture<RaftClientReply> setConfigurationAsync(SetConfigurationRequest request) throws IOException {
        return this.getImpl().setConfigurationAsync(request);
    }

    @Override
    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto r) throws IOException {
        return this.getImpl().requestVote(r);
    }

    @Override
    public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        return this.getImpl().appendEntriesAsync(r);
    }

    @Override
    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        return this.getImpl().appendEntries(r);
    }

    @Override
    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        return this.getImpl().installSnapshot(request);
    }

    public String toString() {
        try {
            return this.getImpl().toString();
        }
        catch (IOException ignored) {
            return this.getClass().getSimpleName() + ":" + this.getId();
        }
    }
}

