/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.NotReplicatedException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftException;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.Preconditions;

public class PendingRequest
implements Comparable<PendingRequest> {
    private final long index;
    private final RaftClientRequest request;
    private final TransactionContext entry;
    private final CompletableFuture<RaftClientReply> future;
    private volatile RaftClientReply delayed;

    PendingRequest(long index, RaftClientRequest request, TransactionContext entry) {
        this.index = index;
        this.request = request;
        this.entry = entry;
        this.future = new CompletableFuture();
    }

    PendingRequest(SetConfigurationRequest request) {
        this(-1L, (RaftClientRequest)request, null);
    }

    long getIndex() {
        return this.index;
    }

    RaftClientRequest getRequest() {
        return this.request;
    }

    public CompletableFuture<RaftClientReply> getFuture() {
        return this.future;
    }

    TransactionContext getEntry() {
        return this.entry;
    }

    synchronized void setException(Throwable e) {
        Preconditions.assertTrue((e != null ? 1 : 0) != 0);
        this.future.completeExceptionally(e);
    }

    synchronized void setReply(RaftClientReply r) {
        Preconditions.assertTrue((r != null ? 1 : 0) != 0);
        this.future.complete(r);
    }

    synchronized void setDelayedReply(RaftClientReply r) {
        Objects.requireNonNull(r);
        Preconditions.assertTrue((this.delayed == null ? 1 : 0) != 0);
        this.delayed = r;
    }

    synchronized void completeDelayedReply() {
        this.setReply(this.delayed);
    }

    synchronized void failDelayedReply() {
        RaftClientRequest.Type type = this.request.getType();
        RaftProtos.ReplicationLevel replication = type.getWrite().getReplication();
        this.setReply(new RaftClientReply(this.delayed, new NotReplicatedException(this.request.getCallId(), replication, this.index)));
    }

    TransactionContext setNotLeaderException(NotLeaderException nle) {
        this.setReply(new RaftClientReply(this.getRequest(), (RaftException)nle, null));
        return this.getEntry();
    }

    @Override
    public int compareTo(PendingRequest that) {
        return Long.compare(this.index, that.index);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(index=" + this.index + ", request=" + this.request;
    }
}

