/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.Preconditions;

class PeerConfiguration {
    private final Map<RaftPeerId, RaftPeer> peers;

    PeerConfiguration(Iterable<RaftPeer> peers) {
        Objects.requireNonNull(peers);
        HashMap<RaftPeerId, RaftPeer> map = new HashMap<RaftPeerId, RaftPeer>();
        for (RaftPeer p : peers) {
            map.put(p.getId(), p);
        }
        this.peers = Collections.unmodifiableMap(map);
    }

    Collection<RaftPeer> getPeers() {
        return Collections.unmodifiableCollection(this.peers.values());
    }

    int size() {
        return this.peers.size();
    }

    public String toString() {
        return this.peers.values().toString();
    }

    RaftPeer getPeer(RaftPeerId id) {
        return this.peers.get(id);
    }

    boolean contains(RaftPeerId id) {
        return this.peers.containsKey(id);
    }

    List<RaftPeer> getOtherPeers(RaftPeerId selfId) {
        ArrayList<RaftPeer> others = new ArrayList<RaftPeer>();
        for (Map.Entry<RaftPeerId, RaftPeer> entry : this.peers.entrySet()) {
            if (selfId.equals((Object)entry.getValue().getId())) continue;
            others.add(entry.getValue());
        }
        return others;
    }

    boolean hasMajority(Collection<RaftPeerId> others, RaftPeerId selfId) {
        Preconditions.assertTrue((!others.contains(selfId) ? 1 : 0) != 0);
        int num = 0;
        if (this.contains(selfId)) {
            ++num;
        }
        for (RaftPeerId other : others) {
            if (this.contains(other)) {
                ++num;
            }
            if (num <= this.size() / 2) continue;
            return true;
        }
        return false;
    }
}

