/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FollowerState
extends Daemon {
    static final Logger LOG = LoggerFactory.getLogger(FollowerState.class);
    private final RaftServerImpl server;
    private volatile Timestamp lastRpcTime = new Timestamp();
    private volatile boolean monitorRunning = true;
    private volatile boolean inLogSync = false;

    FollowerState(RaftServerImpl server) {
        this.server = server;
    }

    void updateLastRpcTime(boolean inLogSync) {
        this.lastRpcTime = new Timestamp();
        LOG.trace("{} update last rpc time to {} {}", new Object[]{this.server.getId(), this.lastRpcTime, inLogSync});
        this.inLogSync = inLogSync;
    }

    Timestamp getLastRpcTime() {
        return this.lastRpcTime;
    }

    boolean shouldWithholdVotes() {
        return this.lastRpcTime.elapsedTimeMs() < (long)this.server.getMinTimeoutMs();
    }

    void stopRunning() {
        this.monitorRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.monitorRunning && this.server.isFollower()) {
            long electionTimeout = this.server.getRandomTimeoutMs();
            try {
                Thread.sleep(electionTimeout);
                if (!this.monitorRunning || !this.server.isFollower()) {
                    LOG.info("{} heartbeat monitor quit", (Object)this.server.getId());
                    break;
                }
                RaftServerImpl raftServerImpl = this.server;
                synchronized (raftServerImpl) {
                    if (!this.inLogSync && this.lastRpcTime.elapsedTimeMs() >= electionTimeout) {
                        LOG.info("{} changes to CANDIDATE, lastRpcTime:{}, electionTimeout:{}ms", new Object[]{this.server.getId(), this.lastRpcTime.elapsedTimeMs(), electionTimeout});
                        this.server.changeToCandidate();
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)((Object)this) + " was interrupted: " + e);
                LOG.trace("TRACE", (Throwable)e);
                return;
            }
            catch (Exception e) {
                LOG.warn((Object)((Object)this) + " caught an exception", (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.server.getId() + ": " + ((Object)((Object)this)).getClass().getSimpleName();
    }
}

