/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ratis.server.impl.RaftConfiguration;
import org.apache.ratis.util.Preconditions;

public class ConfigurationManager {
    private final RaftConfiguration initialConf;
    private final NavigableMap<Long, RaftConfiguration> configurations = new TreeMap<Long, RaftConfiguration>();
    private RaftConfiguration currentConf;

    ConfigurationManager(RaftConfiguration initialConf) {
        this.initialConf = initialConf;
        this.currentConf = initialConf;
    }

    public synchronized void addConfiguration(long logIndex, RaftConfiguration conf) {
        Preconditions.assertTrue((this.configurations.isEmpty() || this.configurations.lastEntry().getKey() < logIndex ? 1 : 0) != 0);
        this.configurations.put(logIndex, conf);
        this.currentConf = conf;
    }

    synchronized RaftConfiguration getCurrent() {
        return this.currentConf;
    }

    synchronized RaftConfiguration removeConfigurations(long index) {
        SortedMap<Long, RaftConfiguration> toRemove = this.configurations.tailMap(index);
        Iterator<Map.Entry<Long, RaftConfiguration>> iter = toRemove.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        this.currentConf = this.configurations.isEmpty() ? this.initialConf : this.configurations.lastEntry().getValue();
        return this.currentConf;
    }

    synchronized int numOfConf() {
        return 1 + this.configurations.size();
    }
}

