/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.grpc.RaftGrpcUtil;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.shaded.io.grpc.stub.StreamObserver;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.shaded.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftServerProtocolService
extends RaftServerProtocolServiceGrpc.RaftServerProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(RaftServerProtocolService.class);
    private final Supplier<RaftPeerId> idSupplier;
    private final RaftServer server;

    public RaftServerProtocolService(Supplier<RaftPeerId> idSupplier, RaftServer server) {
        this.idSupplier = idSupplier;
        this.server = server;
    }

    RaftPeerId getId() {
        return this.idSupplier.get();
    }

    public void requestVote(RaftProtos.RequestVoteRequestProto request, StreamObserver<RaftProtos.RequestVoteReplyProto> responseObserver) {
        try {
            RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable e) {
            RaftGrpcUtil.warn(LOG, () -> this.getId() + ": Failed requestVote " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
            responseObserver.onError((Throwable)RaftGrpcUtil.wrapException(e));
        }
    }

    public StreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(final StreamObserver<RaftProtos.AppendEntriesReplyProto> responseObserver) {
        return new StreamObserver<RaftProtos.AppendEntriesRequestProto>(){
            private final AtomicReference<CompletableFuture<Void>> previousOnNext = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));
            private final AtomicBoolean isClosed = new AtomicBoolean(false);

            public void onNext(RaftProtos.AppendEntriesRequestProto request) {
                CompletableFuture current = new CompletableFuture();
                CompletableFuture previous = this.previousOnNext.getAndSet(current);
                try {
                    RaftServerProtocolService.this.server.appendEntriesAsync(request).thenCombine((CompletionStage)previous, (reply, v) -> {
                        if (!this.isClosed.get()) {
                            responseObserver.onNext(reply);
                        }
                        current.complete(null);
                        return null;
                    });
                }
                catch (Throwable e) {
                    RaftGrpcUtil.warn(LOG, () -> RaftServerProtocolService.this.getId() + ": Failed appendEntries " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
                    responseObserver.onError((Throwable)RaftGrpcUtil.wrapException(e, request.getServerRequest().getCallId()));
                    current.completeExceptionally(e);
                }
            }

            public void onError(Throwable t) {
                RaftGrpcUtil.warn(LOG, () -> RaftServerProtocolService.this.getId() + ": appendEntries onError", t);
            }

            public void onCompleted() {
                if (this.isClosed.compareAndSet(false, true)) {
                    LOG.info("{}: appendEntries completed", (Object)RaftServerProtocolService.this.getId());
                    responseObserver.onCompleted();
                }
            }
        };
    }

    public StreamObserver<RaftProtos.InstallSnapshotRequestProto> installSnapshot(final StreamObserver<RaftProtos.InstallSnapshotReplyProto> responseObserver) {
        return new StreamObserver<RaftProtos.InstallSnapshotRequestProto>(){

            public void onNext(RaftProtos.InstallSnapshotRequestProto request) {
                try {
                    RaftProtos.InstallSnapshotReplyProto reply = RaftServerProtocolService.this.server.installSnapshot(request);
                    responseObserver.onNext((Object)reply);
                }
                catch (Throwable e) {
                    RaftGrpcUtil.warn(LOG, () -> RaftServerProtocolService.this.getId() + ": Failed installSnapshot " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
                    responseObserver.onError((Throwable)RaftGrpcUtil.wrapException(e));
                }
            }

            public void onError(Throwable t) {
                RaftGrpcUtil.warn(LOG, () -> RaftServerProtocolService.this.getId() + ": installSnapshot onError", t);
            }

            public void onCompleted() {
                LOG.info("{}: installSnapshot completed", (Object)RaftServerProtocolService.this.getId());
                responseObserver.onCompleted();
            }
        };
    }
}

