/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.client.RaftClientProtocolClient;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.shaded.io.grpc.stub.StreamObserver;
import org.apache.ratis.shaded.proto.RaftProtos;

public class RaftClientProtocolProxy
implements Closeable {
    private final RaftClientProtocolClient proxy;
    private final Function<RaftPeer, CloseableStreamObserver> responseHandlerCreation;
    private RpcSession currentSession;

    public RaftClientProtocolProxy(ClientId clientId, RaftPeer target, Function<RaftPeer, CloseableStreamObserver> responseHandlerCreation, RaftProperties properties) {
        this.proxy = new RaftClientProtocolClient(clientId, target, properties);
        this.responseHandlerCreation = responseHandlerCreation;
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentSession();
        this.proxy.close();
    }

    public String toString() {
        return "ProxyTo:" + this.proxy.getTarget();
    }

    public void closeCurrentSession() {
        if (this.currentSession != null) {
            this.currentSession.close();
            this.currentSession = null;
        }
    }

    public void onNext(RaftProtos.RaftClientRequestProto request) {
        if (this.currentSession == null) {
            this.currentSession = new RpcSession(this.responseHandlerCreation.apply(this.proxy.getTarget()));
        }
        this.currentSession.requestObserver.onNext((Object)request);
    }

    public void onError() {
        if (this.currentSession != null) {
            this.currentSession.onError();
        }
    }

    class RpcSession
    implements Closeable {
        private final StreamObserver<RaftProtos.RaftClientRequestProto> requestObserver;
        private final CloseableStreamObserver responseHandler;
        private boolean hasError = false;

        RpcSession(CloseableStreamObserver responseHandler) {
            this.responseHandler = responseHandler;
            this.requestObserver = RaftClientProtocolProxy.this.proxy.append(responseHandler);
        }

        void onError() {
            this.hasError = true;
        }

        @Override
        public void close() {
            if (!this.hasError) {
                try {
                    this.requestObserver.onCompleted();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.responseHandler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface CloseableStreamObserver
    extends StreamObserver<RaftProtos.RaftClientReplyProto>,
    Closeable {
    }
}

